package cn.com.duiba.activity.center.biz.pool;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public class ThreadPoolLotteryService {

	/**
	 * 线程池最大线程数
	 */
	private static final int PoolMaxThread = 50;

	private static ThreadPoolLotteryService service = new ThreadPoolLotteryService();

	public static ThreadPoolLotteryService get() {
		return service;
	}

	private ExecutorService pool = Executors.newFixedThreadPool(PoolMaxThread);

	private ThreadPoolLotteryService() {

	}

	/**
	 * 提交任务
	 */
	public void submit(Runnable runnable) {
		pool.submit(runnable);
	}

	public int dumpSize() {
		Integer activeThread = ((ThreadPoolExecutor) pool).getActiveCount();
		return activeThread;
	}

}
