package cn.com.duiba.activity.center.biz.remoteservice.impl.creditgame;

import cn.com.duiba.activity.center.api.dto.creditgame.AddCreditFlowRecordDto;
import cn.com.duiba.activity.center.api.remoteservice.creditgame.RemoteAddCreditFlowRecordService;
import cn.com.duiba.activity.center.biz.entity.creditgame.AddCreditFlowRecordEntity;
import cn.com.duiba.activity.center.biz.service.creditgame.AddCreditFlowRecordService;
import lombok.extern.slf4j.Slf4j;

import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class RemoteAddCreditFlowRecordServiceImpl implements RemoteAddCreditFlowRecordService{
    @Autowired
    private AddCreditFlowRecordService addCreditFlowRecordService;
    
    private static Logger log = LoggerFactory.getLogger(RemoteAddCreditFlowRecordServiceImpl.class);
    
    public int insert(AddCreditFlowRecordDto addCreditFlowRecordDto){
        try {
            AddCreditFlowRecordEntity addCreditFlowRecordEntity = new AddCreditFlowRecordEntity();
            BeanUtils.copyProperties(addCreditFlowRecordEntity,addCreditFlowRecordDto);
            addCreditFlowRecordService.insert(addCreditFlowRecordEntity);
        }catch(Throwable t){
            log.error("增加加积分流水记录异常");
        }
        return 0;
    }
}
