package cn.com.duiba.activity.center.biz.remoteservice.impl.elasticgifts;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticTakeOrderDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.RequestParamsDto;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsBizCodeEnum;
import cn.com.duiba.activity.center.api.remoteservice.elasticgifts.RemoteElasticGiftsService;
import cn.com.duiba.activity.center.biz.service.elasticgifts.ElasticGiftsService;
import cn.com.duiba.dcommons.domain.Tuple;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("remoteElasticGiftsService")
public class RemoteElasticGiftsServiceImpl implements RemoteElasticGiftsService {

    private static Logger LOGGER = LoggerFactory.getLogger(RemoteElasticGiftsServiceImpl.class);

    @Autowired
    private ElasticGiftsService elasticGiftsService;

    @Override
    public DubboResult<Tuple.Tuple2<ElasticGiftsDto, List<ElasticGiftsTermDto>>> getElasticGiftsForMobile(ElasticGiftsBizCodeEnum bizCode, Long appId) {
        try {
            Tuple.Tuple2<ElasticGiftsDto, List<ElasticGiftsTermDto>> result = elasticGiftsService.getElasticGiftsForMobile(bizCode, appId);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("getElasticGiftsForMobile error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<String> takeOrder(ElasticGiftsDto dto, Long itemId, Long appId, Long consumerId, RequestParamsDto requestParams) {
        try {
            String result = elasticGiftsService.takeOrder(dto, itemId, appId, consumerId, requestParams);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("takeOrder error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<ElasticTakeOrderDto> checkElasticTakeOrder(Long egTermId, Long appId) {
        try {
            ElasticTakeOrderDto result = elasticGiftsService.checkElasticTakeOrder(egTermId, appId);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("checkElasticTakeOrder error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
