package cn.com.duiba.activity.center.biz.remoteservice.impl.game;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.game.GameOrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.game.GameOrdersSimpleDto;
import cn.com.duiba.activity.center.api.remoteservice.game.RemoteGameOrdersSimpleService;
import cn.com.duiba.activity.center.biz.service.game.GameOrdersSimpleService;
import org.springframework.stereotype.Service;

/**
 * Created by ZQian on 2016/8/1.
 */
@Service
public class RemoteGameOrdersSimpleServiceImpl implements RemoteGameOrdersSimpleService {

    @Autowired
    private GameOrdersSimpleService gameOrdersSimpleService;

    @Override
    public DubboResult<GameOrdersDto> find(Long gameOrderId) {
        return DubboResult.successResult(gameOrdersSimpleService.find(gameOrderId));
    }

    @Override
    public DubboResult<GameOrdersDto> findByAppAndDeveloperBizId(Long appId, String bizId) {
        return DubboResult.successResult(gameOrdersSimpleService.findByAppAndDeveloperBizId(appId, bizId));
    }

    @Override
    public DubboResult<List<GameOrdersDto>> findByIds(List<Long> ids) {
        return DubboResult.successResult(gameOrdersSimpleService.findByIds(ids));
    }

    @Override
    public DubboResult<GameOrdersDto> insert(GameOrdersDto gameOrdersDO) {
        gameOrdersSimpleService.insert(gameOrdersDO);
        return DubboResult.successResult(gameOrdersDO);
    }

    @Override
    public DubboResult<Integer> findConsumerFreeNumber(Long consumerId, Long operatingActivityId) {
        return DubboResult.successResult(gameOrdersSimpleService.findConsumerFreeNumber(consumerId, operatingActivityId));
    }

    @Override
    public DubboResult<Integer> findConsumerFreeNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return DubboResult.successResult(gameOrdersSimpleService.findConsumerFreeNumberByDate(consumerId, operatingActivityId, start, end));
    }

    @Override
    public DubboResult<Integer> findConsumerLimitNumber(Long consumerId, Long operatingActivityId) {
        return DubboResult.successResult(gameOrdersSimpleService.findConsumerLimitNumber(consumerId, operatingActivityId));
    }

    @Override
    public DubboResult<Integer> findConsumerLimitNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return DubboResult.successResult(gameOrdersSimpleService.findConsumerFreeNumberByDate(consumerId, operatingActivityId, start, end));
    }

    @Override
    public DubboResult<Integer> countConsumerByPrizeId(Long consumerId, Long operatingActivityId, Long prizeId) {
        return DubboResult.successResult(gameOrdersSimpleService.countConsumerByPrizeId(consumerId, operatingActivityId, prizeId));
    }

    @Override
    public DubboResult<Integer> countConsumerByGameConfigDuibaId(Long consumerId, Long gameConfigDuibaId) {
        return DubboResult.successResult(gameOrdersSimpleService.countConsumerByGameConfigDuibaId(consumerId, gameConfigDuibaId));
    }

    @Override
    public DubboResult<List<Long>> findOverdueOrder() {
        return DubboResult.successResult(gameOrdersSimpleService.findOverdueOrder());
    }

    @Override
    public DubboResult<Long> countRow(Map<String, Object> params) {
        return DubboResult.successResult(gameOrdersSimpleService.countRow(params));
    }

    @Override
    public DubboResult<List<GameOrdersSimpleDto>> findByLimit(Map<String, Object> params) {
        return DubboResult.successResult(gameOrdersSimpleService.findByLimit(params));
    }

    @Override
    public DubboResult<List<DeveloperActivityStatisticsDto>> countFailByOperatingActivityIds(List<Long> ids) {
        return DubboResult.successResult(gameOrdersSimpleService.countFailByOperatingActivityIds(ids));
    }
}
