/**
 * Project Name:activity-center-biz
 * File Name:RemoteLittleGameBackendServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.remoteservice.impl.littleGame
 * Date:2016年9月29日下午8:14:53
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.remoteservice.impl.littleGame;

import java.util.List;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;

import cn.com.duiba.activity.center.api.dto.littlegame.LittleGameDto;
import cn.com.duiba.activity.center.api.remoteservice.littlegame.RemoteLittleGameBackendService;
import cn.com.duiba.activity.center.biz.entity.littlegame.LittleGameEntity;
import cn.com.duiba.activity.center.biz.service.littlegame.LittleGameService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

/**
 * ClassName:RemoteLittleGameBackendServiceImpl <br/>
 * Date:     2016年9月29日 下午8:14:53 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class RemoteLittleGameBackendServiceImpl implements RemoteLittleGameBackendService{
    
    private static Logger   log = LoggerFactory.getLogger(RemoteLittleGameBackendServiceImpl.class);
    
    @Resource
    private LittleGameService littleGameService;
    @Override
    public DubboResult<LittleGameDto> queryLittleGameById(Long id) {
        LittleGameDto dto;
        try{
            LittleGameEntity entity = this.littleGameService.selectById(id);
            if(entity==null){
                dto = null;
            } else {
                dto = new LittleGameDto();
                ObjectUtil.convert(entity, dto);
            }
            return DubboResult.successResult(dto);
        } catch (Exception e){
            log.error("RemoteLittleGameBackendService.queryLittleGameById("+id+") error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<List<LittleGameDto>> queryLittleGameByPage(String title, Integer offset, Integer max) {
        List<LittleGameDto> rs;
        try{
            List<LittleGameEntity> list = this.littleGameService.selectList(title, offset, max);
            if(list==null){
                rs = null;
            } else {
                rs = Lists.newArrayList();
                ObjectUtil.convertList(list, rs, LittleGameDto.class);
            }
            return DubboResult.successResult(rs);
        } catch (Exception e){
            log.error("RemoteLittleGameBackendService.queryLittleGameByPage("+title+","+offset+","+max+") error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Long> queryLittleGameCount(String title) {
        Long count;
        try{
            count = this.littleGameService.selectCount(title);
            return DubboResult.successResult(count);
        } catch (Exception e){
            log.error("RemoteLittleGameBackendService.queryLittleGameCount("+title+") error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Long> saveOrUpdateLittleGame(LittleGameDto dto) {
        
        try{
            Long rs;
            if(dto==null){
                throw new Exception("dto is null!!!");
            }
            LittleGameEntity entity = new LittleGameEntity();
            ObjectUtil.convert(dto, entity);
            if(dto.getId()==null){
                this.littleGameService.insert(entity);
                rs = entity.getId();
            }else{
                this.littleGameService.update(entity);
                rs = entity.getId();
            }
            return DubboResult.successResult(rs);
        } catch (Exception e){
            log.error("RemoteLittleGameBackendService.saveOrUpdateLittleGame("+dto.toString()+") error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> removeLittleGame(Long id) {
        try{
            LittleGameEntity entity = new LittleGameEntity();
            entity.setId(id);
            entity.setLittleGameDelete(true);
            this.littleGameService.update(entity);
            return DubboResult.successResult(Boolean.TRUE);
        } catch(Exception e){
            log.error("RemoteLittleGameBackendService.removeLittleGame("+id+") error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}

