/**
 * Project Name:activity-center-biz
 * File Name:RemoteActivityPrizeOptionServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.remoteservice.impl.prize
 * Date:2016年7月26日下午4:05:28
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.remoteservice.impl.prize;

import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.api.remoteservice.prize.RemoteActivityPrizeOptionService;
import cn.com.duiba.activity.center.biz.service.prize.ActivityPrizeOptionService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteActivityPrizeOptionServiceImpl <br/>
 * Date:     2016年7月26日 下午4:05:28 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class RemoteActivityPrizeOptionServiceImpl implements RemoteActivityPrizeOptionService{
    
    private static Logger log = LoggerFactory.getLogger(RemoteActivityPrizeOptionServiceImpl.class);
    
    @Autowired
    private ActivityPrizeOptionService activityPrizeOptionService;
    @Autowired
    private RemoteStockService remoteStockService;

    @Override
    public DubboResult<Boolean> delOption(Long optionId) {
        return DubboResult.successResult(activityPrizeOptionService.deleteOption(optionId));
    }

    @Override
    public DubboResult<Long> saveOrUpdateOption(ActivityPrizeOptionDto prizeOption) {
        return DubboResult.successResult(activityPrizeOptionService.saveOrUpdateOption(prizeOption));
    }

    @Override
    public DubboResult<List<ActivityPrizeOptionDto>> queryActivityOptionsByConfigId(Long configId,String activityType) {
        return DubboResult.successResult(activityPrizeOptionService.queryActivityOptionsByConfigId(configId, activityType));
    }

    @Override
    public DubboResult<ActivityPrizeOptionDto> find(Long id) {
        return DubboResult.successResult(activityPrizeOptionService.find(id));
    }

    @Override
    public DubboResult<List<ActivityPrizeOptionDto>> queryActivityOptionsByConfigIds(List<Long> configIds,
                                                                                                String activityType) {
        
        return DubboResult.successResult(activityPrizeOptionService.queryActivityOptionsByConfigIds(configIds,activityType));
    }

    @Override
    public DubboResult<List<ActivityPrizeOptionDto>> queryActivityOptionByActivityType(String activityType,
                                                                                       Integer offset, Integer max) {
        try{
            if(offset==null){
                offset = 0;
            }
            if(max==null){
                max = 20;
            }
            List<ActivityPrizeOptionDto> dtos = this.activityPrizeOptionService.queryActivityOptionsByActivityType(activityType, offset, max);
            return DubboResult.successResult(dtos);
        } catch (Exception e){
            log.error("RemoteActivityPrizeOptionService.queryActivityOptionByActivityType("+activityType+","+offset+","+max+") error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Long> queryCountByActivityType(String activityType) {
        try{
            Long count = this.activityPrizeOptionService.queryCountByActivityType(activityType);
            return DubboResult.successResult(count);
        } catch (Exception e){
            log.error("RemoteActivityPrizeOptionService.queryCountByActivityType("+activityType+") error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ActivityPrizeOptionDto>> queryRandomGift(Integer number, List<Long> ids) {
        try{
            if(number==null){
                return DubboResult.failResult("请输入查询的个数");
            }
            List<ActivityPrizeOptionDto> dtos = this.activityPrizeOptionService.queryActivityOptionsByActivityType(ActivityPrizeOptionDto.Special_Activity_Type_gift,null,null);
            
            List<ActivityPrizeOptionDto> rs;
            if(CollectionUtils.isNotEmpty(dtos)){
                List<Long> pId = Lists.newArrayList();      //查询出奖项库存为0的id，放在此集合中
                
                //批量查询奖项的库存
                List<Long> stockIds = Lists.newArrayList();
                Map<Long,Long> stockPrizeMap = Maps.newHashMap();//<stockId,prizeId>
                for(ActivityPrizeOptionDto dto:dtos){
                    if(dto.getStockId()!=null){
                        stockIds.add(dto.getStockId());
                        stockPrizeMap.put(dto.getStockId(), dto.getId());
                    }
                }
                Map<Long,Long> stockMap = this.remoteStockService.findBatch(stockIds).getResult();//调批量查询库存的接口
                for(Long stockId:stockIds){
                    Long stockValue = stockMap.get(stockId);
                    if(stockValue!=null&&stockValue<=0){//记录没有库存的奖项id
                        Long prizeId = stockPrizeMap.get(stockId);
                        if(prizeId!=null){
                            pId.add(prizeId);
                        }
                    }
                }
                if(ids==null){
                    ids = Lists.newArrayList();
                }
                ids.addAll(pId);
                rs = this.activityPrizeOptionService.queryRandomByActivityType(ActivityPrizeOptionDto.Special_Activity_Type_gift, number, ids);
            } else {//没有礼包，就甭随机查奖项了
                rs = Lists.newArrayList();
            }
            
            return DubboResult.successResult(rs);
        } catch (Exception e){
            log.error("RemoteActivityPrizeOptionService.queryRandomGift error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }


}

