package cn.com.duiba.activity.center.biz.remoteservice.impl.quizz;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzBrickDto;
import cn.com.duiba.activity.center.api.remoteservice.quizz.RemoteDuibaQuizzBrickService;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzBrickService;

@Service
public class RemoteDuibaQuizzBrickServiceImpl implements
		RemoteDuibaQuizzBrickService {

	@Autowired
	private DuibaQuizzBrickService duibaQuizzBrickService;
	
	@Override
	public DuibaQuizzBrickDto find(Long id) {
		return duibaQuizzBrickService.find(id);
	}

	@Override
	public String getBrickContentById(Long id) {
		return duibaQuizzBrickService.getBrickContentById(id);
	}

	@Override
	public DuibaQuizzBrickDto findNoContent(Long id) {
		return duibaQuizzBrickService.findNoContent(id);
	}

	@Override
	public DuibaQuizzBrickDto insert(DuibaQuizzBrickDto duibaQuestionAnswerBrick) {
		duibaQuizzBrickService.insert(duibaQuestionAnswerBrick);
		return duibaQuestionAnswerBrick;
	}

	@Override
	public void update4Admin(Long id, String title, String content, String md5) {
		duibaQuizzBrickService.update4Admin(id, title, content, md5);
	}

	@Override
	public DuibaQuizzBrickDto findByTitle(String title) {
		return duibaQuizzBrickService.findByTitle(title);
	}

	@Override
	public void open(Long id) {
		duibaQuizzBrickService.open(id);
	}

	@Override
	public void disable(Long id) {
		duibaQuizzBrickService.disable(id);
	}

	@Override
	public List<DuibaQuizzBrickDto> findPage(Map<String, Object> queryMap) {
		return duibaQuizzBrickService.findPage(queryMap);
	}

	@Override
	public Long findPageCount() {
		return duibaQuizzBrickService.findPageCount();
	}

	@Override
	public List<DuibaQuizzBrickDto> findAll() {
		return duibaQuizzBrickService.findAll();
	}

}
