package cn.com.duiba.activity.center.biz.service.commonactivity;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.enums.DuibaActivityTypeEnum;
import cn.com.duiba.dcommons.domain.Tuple;

import java.util.List;
import java.util.Map;

/**
 * 活动常用方法
 * Created by gyf .
 */
public interface ActivityToolService {

    /**
     * 获取兑吧活动标题
     * 参数为兑吧活动 id type
     * @param activityId
     * @param type
     * @return
     */
    String getTitle(Long activityId, DuibaActivityTypeEnum type);

    /**
     * 手机端 url
     * @param activityId
     * @return
     */
    Map<Long, String> getMobileUrlMap(List<Tuple.Tuple2<Integer, Long>> activities);

    /**
     * 根据 appId activityId type 获取 operatingactivity
     * @param appId
     * @param activityId
     * @param type
     * @return
     */
    OperatingActivityDto findAppActivity(Long appId, Long activityId, Integer type);

    /**
     * 批量获取operatingactivity
     * @param appId
     * @param activities
     * @return
     */
    List<OperatingActivityDto> findAppActivitys(Long appId, List<Tuple.Tuple2<Integer, Long>> activities);

    static abstract class ActivityToolServiceAdapter implements ActivityToolService {

        @Override
        public String getTitle(Long activityId, DuibaActivityTypeEnum type) {
            return null;
        }

        @Override
        public Map<Long, String> getMobileUrlMap(List<Tuple.Tuple2<Integer, Long>> activities) {
            return null;
        }

        @Override
        public OperatingActivityDto findAppActivity(Long appId, Long activityId, Integer type) {
            return null;
        }

        @Override
        public List<OperatingActivityDto> findAppActivitys(Long appId, List<Tuple.Tuple2<Integer, Long>> activities) {
            return null;
        }

        public abstract String getTitle(Long activityId);
    }
}
