package cn.com.duiba.activity.center.biz.service.commonactivity.impl;

import cn.com.duiba.activity.center.biz.dao.duibaactivity.DuibaActivityDao;
import cn.com.duiba.activity.center.biz.entity.duibaactivity.DuibaActivityEntity;
import cn.com.duiba.activity.center.biz.service.commonactivity.ActivityToolService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 专题活动
 */
@Service("duibaActivityToolServiceImpl")
public class DuibaActivityToolServiceImpl extends ActivityToolService.ActivityToolServiceAdapter {

    @Autowired
    private DuibaActivityDao duibaActivityDao;

    @Override
    public String getTitle(Long activityId) {
        if (activityId == null) {
            throw new RuntimeException("参数不全");
        }
        DuibaActivityEntity entity = duibaActivityDao.find(activityId);
        if (entity == null || entity.getDeleted()) {
            throw new RuntimeException("活动不存在");
        }
        return entity.getTitle();
    }

}
