/**
 * Project Name:activity-center-biz File Name:CenterConfigServiceImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.service.config.impl Date:2016年9月30日上午11:48:04 Copyright (c) 2016, duiba.com.cn
 * All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.service.config.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.dao.config.CenterConfigDao;
import cn.com.duiba.activity.center.biz.entity.config.CenterConfigEntity;
import cn.com.duiba.activity.center.biz.service.config.CenterConfigService;

import com.google.common.base.Joiner;

/**
 * ClassName:CenterConfigServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年9月30日 上午11:48:04 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class CenterConfigServiceImpl implements CenterConfigService {

    // center_config中维护的待推送app配置项的type
    private static final String TYPE_PUSH_APPS = "TODAY_ROB_SECKILL_PUSH_APPS";
    
    @Autowired
    private CenterConfigDao    centerConfigDao;

    @Override
    public CenterConfigEntity findPushAppsConfig() {
        return centerConfigDao.selectByType(TYPE_PUSH_APPS);
    }

    @Override
    public void updatePushAppsConfig(List<Long> appIdList) {
        String appIdsStr = Joiner.on(',').join(appIdList);
        CenterConfigEntity config = findPushAppsConfig();
        centerConfigDao.updateByType(config.getVersion()+1, appIdsStr, TYPE_PUSH_APPS);
    }
}
