package cn.com.duiba.activity.center.biz.service.elasticgifts;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsAppListDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsAppSaveResultDto;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsBizCodeEnum;

import java.util.List;

/**
 * 弹层活动app管理service
 */
public interface ElasticGiftsAppService {

    /**
     * 根据业务场景和活动 id,筛选 所有 app 关系
     * @param bizCode
     * @param activityId
     * @return
     */
    List<ElasticGiftsAppListDto> getAllElasticGiftsApps(ElasticGiftsBizCodeEnum bizCode, Long activityId);

    /**
     * 删除
     * @param bizCode
     * @param appIds
     * @return
     */
    Boolean delete(ElasticGiftsBizCodeEnum bizCode, List<Long> appIds) throws Exception;

    /**
     * 保存
     * @param bizCode
     * @param appIds
     * @param activityId
     * @return
     */
    List<ElasticGiftsAppSaveResultDto> save(List<Long> toDeleteIds, ElasticGiftsBizCodeEnum bizCode, List<Long> appIds, Long activityId);

    /**
     * 保存或者更新活动 id,根据 appid
     * @param elasticGiftsId
     * @param appId
     * @return
     */
    Boolean saveElasticGiftsIdByAppId(Long elasticGiftsId, Long appId, ElasticGiftsBizCodeEnum bizCode);
}
