/**
 * Project Name:activity-center-biz File Name:GameCenterShieldService.java Package
 * Name:cn.com.duiba.activity.center.biz.service.gamecenter Date:2016年10月20日下午1:49:26 Copyright (c) 2016, duiba.com.cn
 * All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.service.gamecenter;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.gamecenter.ShieldItemDto;

/**
 * ClassName:GameCenterShieldService <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月20日 下午1:49:26 <br/>
 *
 * @author Zhuzhiyong
 * @version
 * @see
 * @since JDK 1.6
 */
public interface ActivityShieldService {

    /**
     * addShield:批量添加屏蔽. <br/>
     *
     * @author zhuzhiyong
     * @param shieldList the shieldList
     * @return the boolean
     * @since JDK 1.6
     */
    Boolean addShield(List<ShieldItemDto> shieldList);

    /**
     * removeShield:批量还原屏蔽. <br/>
     * id为逻辑主键
     * 
     * @author zhuzhiyong
     * @param ids the ids
     * @return the boolean
     * @since JDK 1.6
     */
    Boolean removeShield(List<Long> ids);

    /**
     * findShieldByAppId:根据主键id查询屏蔽记录. <br/>
     *
     * @author zhuzhiyong
     * @param appId the app id
     * @return the list
     * @since JDK 1.6
     */
    ShieldItemDto find(Long id);

    /**
     * Find shield.
     *
     * @param id the id
     * @return the activity shield entity
     */
    ShieldItemDto findShield(Long appId, Integer activityType, Long activityId);

    /**
     * findShieldList:查询屏蔽列表，支持分页，支持按指定字段过滤. <br/>
     * 分页参数：offset, max <br>
     * 支持单独参数过滤：appId <br>
     * 支持组合参数过滤：appId & activityType <br>
     *
     * @author zhuzhiyong
     * @param paramMap the param map
     * @return the list
     */
    List<ShieldItemDto> findShieldList(Map<String, Object> paramMap);

    /**
     * countShield:查询指定条件的记录数. <br/>
     * 支持单独参数过滤：appId <br>
     * 支持组合参数过滤：appId & activityType <br>
     *
     * @param paramMap the param map
     * @return the integer
     */
    Integer countShield(Map<String, Object> paramMap);
}
