/**
 * Project Name:activity-center-biz File Name:GameCenterHomeServiceImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.service.gamecenter.impl Date:2016年10月21日下午1:55:51 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.direct.ActivityBlackList4DeveloperDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.DefinedActivityTypesDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterHomeResourceDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterHomeResourceListDto;
import cn.com.duiba.activity.center.api.remoteservice.direct.RemoteActivityBlackList4DeveloperService;
import cn.com.duiba.activity.center.biz.dao.gamecenter.ActivityShieldDao;
import cn.com.duiba.activity.center.biz.dao.gamecenter.GameCenterResourceDao;
import cn.com.duiba.activity.center.biz.dao.gamecenter.GameCenterResourceLocationDao;
import cn.com.duiba.activity.center.biz.entity.gamecenter.GameCenterResourceEntity;
import cn.com.duiba.activity.center.biz.entity.gamecenter.GameCenterResourceLocationEntity;
import cn.com.duiba.activity.center.biz.entity.littlegame.LittleGameEntity;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterException;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterHomeService;
import cn.com.duiba.activity.center.biz.service.littlegame.LittleGameService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:GameCenterHomeServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月21日 下午1:55:51 <br/>
 * 
 * @author zhuzhiyong
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class GameCenterHomeServiceImpl implements GameCenterHomeService {

    private static final Logger                      log = LoggerFactory.getLogger(GameCenterHomeServiceImpl.class);

    @Resource
    private GameCenterResourceDao                    gameCenterResourceDao;
    @Resource
    private GameCenterResourceLocationDao            gameCenterResourceLocationDao;
    @Resource
    private LittleGameService                        littleGameService;
    @Resource
    private ActivityShieldDao                        activityShieldDao;
    @Resource
    private RemoteAppService                         remoteAppService;
    @Resource
    private RemoteActivityBlackList4DeveloperService remoteActivityBlackList4DeveloperService;

    @Override
    public GameCenterHomeResourceListDto findResourceByLocationAndAppId(String locationName, Long appId, Integer offset,
                                                                        Integer max) throws GameCenterException {

        GameCenterHomeResourceListDto gameCenterHomeResourceListDto = new GameCenterHomeResourceListDto();
        List<GameCenterResourceEntity> entities = gameCenterResourceDao.findResourceByLocationId(findLocationIdByName(locationName));
        if (CollectionUtils.isEmpty(entities)) {
            return gameCenterHomeResourceListDto;
        }

        List<GameCenterHomeResourceDto> gameCenterHomeResourceDtoList = new ArrayList<GameCenterHomeResourceDto>();
        GameCenterHomeResourceDto temp;

        Long developerId = findDeveloperIdByAppId(appId);
        if (developerId == null) {
            return gameCenterHomeResourceListDto;
        }

        for (GameCenterResourceEntity gameCenterResourceEntity : entities) {
            if (gameCenterResourceEntity.getActivityType() == DefinedActivityTypesDto.LITTLE_GAME) {
                if (filterByActivityBlacklist(gameCenterResourceEntity.getActivityId(),
                                              ActivityBlackList4DeveloperDto.TypeDuibaLittleGame, developerId)) {
                    continue;
                }

                LittleGameEntity littleGameEntity = littleGameService.selectById(gameCenterResourceEntity.getActivityId());
                if (Utils.filterLittleGameByStatus(littleGameEntity, gameCenterResourceEntity.getActivityId())) {
                    continue;
                }

                // 开发者屏蔽的小游戏
                if (hasShield(appId, DefinedActivityTypesDto.LITTLE_GAME, gameCenterResourceEntity.getActivityId())) {
                    continue;
                }

                temp = new GameCenterHomeResourceDto();
                temp.setActivityId(gameCenterResourceEntity.getActivityId());
                temp.setActivityType(gameCenterResourceEntity.getActivityType());
                temp.setGmtCreate(gameCenterResourceEntity.getGmtCreate());
                temp.setGmtModified(gameCenterResourceEntity.getGmtModified());
                temp.setLocationId(gameCenterResourceEntity.getResourceLocationId());
                temp.setTitle(littleGameEntity.getLittleGameTitle());
                temp.setDescription(littleGameEntity.getLittleGameRecomDescribe());
                temp.setBannerImg(littleGameEntity.getLittleGameBannerImg());
                temp.setRecommendImg(littleGameEntity.getLittleGameSmallImg()); // 使用缩略图
                temp.setIconImg(littleGameEntity.getLittleGameIconImg());
                gameCenterHomeResourceDtoList.add(temp);
            } else {
                // TODO 活动
                // 活动黑名单过滤
                // 定向活动过滤
                // 活动状态过滤
            }
        }

        if (gameCenterHomeResourceDtoList.isEmpty()) {
            return gameCenterHomeResourceListDto;
        }

        // 根据修改时间倒序
        Collections.sort(gameCenterHomeResourceDtoList, new Comparator<GameCenterHomeResourceDto>() {

            @Override
            public int compare(GameCenterHomeResourceDto o1, GameCenterHomeResourceDto o2) {
                return o1.getGmtModified().compareTo(o2.getGmtModified());
            }
        });

        gameCenterHomeResourceListDto.setCount(gameCenterHomeResourceDtoList.size());
        gameCenterHomeResourceListDto.setGameCenterHomeResourceDtoList(Utils.subList(gameCenterHomeResourceDtoList,
                                                                                     offset, max));
        return gameCenterHomeResourceListDto;
    }

    private Long findLocationIdByName(String name) throws GameCenterException {
        GameCenterResourceLocationEntity entity = gameCenterResourceLocationDao.findResourceLocationByName(name);
        if (entity == null) {
            throw new GameCenterException("No this location found:" + name);
        }
        return entity.getId();
    }

    private boolean hasShield(Long appId, Integer activityType, Long activityId) {
        return activityShieldDao.findShield(appId, activityType, activityId) != null;
    }

    private boolean filterByActivityBlacklist(Long activityId, Integer activityType, Long developerId) {
        DubboResult<Boolean> dubboResult = remoteActivityBlackList4DeveloperService.isExistBlackByActivityIdAndActivityTypeAndDeveloperId(activityId,
                                                                                                                                          activityType,
                                                                                                                                          developerId);
        // 黑名单过滤
        if (dubboResult.isSuccess() && dubboResult.getResult().booleanValue()) {
            log.debug("LittleGame is filtered by activity blacklist. DeveloperId is {}, littleGameId is {}",
                      developerId, activityId);
            return true;
        }
        return false;
    }

    private Long findDeveloperIdByAppId(Long appId) {
        AppDO appDO = remoteAppService.find(appId);
        if (appDO == null) {
            log.error("appId is invalid: no record found: {}", appId);
            return null;
        }
        return appDO.getDeveloperId();
    }
}
