/**
 * Project Name:activity-center-biz File Name:MultiActivityQueryingServiceImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.service.gamecenter.impl Date:2016年10月20日下午7:28:45 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.duibaactivity.DuibaActivityDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.DefinedActivityTypesDto;
import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzDto;
import cn.com.duiba.activity.center.api.dto.seconds_kill.DuibaSecondsKillActivityDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.DuibaSingleLotteryDto;
import cn.com.duiba.activity.center.biz.service.duibaactivity.DuibaActivityService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerService;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterException;
import cn.com.duiba.activity.center.biz.service.gamecenter.GeneralActivityItem;
import cn.com.duiba.activity.center.biz.service.gamecenter.MultiActivityQueryingService;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessService;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolService;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameService;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzService;
import cn.com.duiba.activity.center.biz.service.seconds_kill.DuibaSecondsKillActivityService;
import cn.com.duiba.activity.center.biz.service.singlelottery.DuibaSingleLotteryService;
import cn.com.duiba.service.domain.dataobject.DuibaSeckillDO;
import cn.com.duiba.service.remoteservice.RemoteDuibaSeckillService;

/**
 * ClassName:MultiActivityQueryingServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月20日 下午7:28:45 <br/>
 * 
 * @author Zhuzhiyong
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class MultiActivityQueryingServiceImpl implements MultiActivityQueryingService {

    @Resource
    private DuibaHdtoolService              duibaHdtoolService;              // 活动工具1

    @Resource
    private DuibaActivityService            duibaActivityService;            // 活动专题 2

    @Resource
    private DuibaSingleLotteryService       duibaSingleLotteryService;       // 单品抽奖 3

    @Resource
    private DuibaSecondsKillActivityService duibaSecondsKillActivityService; // 秒杀专题 11

    @Resource
    private DuibaNgameService               duibaNgameService;               // 新游戏 28

    @Resource
    private DuibaQuestionAnswerService      duibaQuestionAnswerService;      // 答题30

    // TODO DUBBO接口？
    @Resource
    private RemoteDuibaSeckillService       duibaSeckillService;             // 秒杀活动 40

    @Resource
    private DuibaQuizzService               duibaQuizzService;               // 测试题 41

    @Resource
    private DuibaGuessService               duibaGuessService;               // 竞猜 42

    @Override
    public GeneralActivityItem findActivityByTypeAndId(Integer activityType,
                                                       Long activityId) throws GameCenterException {

        String title, bannerImg, recImg, iconImg, description;
        Integer status;
        switch (activityType.intValue()) {
            case DefinedActivityTypesDto.NEW_HDTOOL: // 新活动工具
                DuibaHdtoolDto duibaHdtoolDto = duibaHdtoolService.find(activityId);
                title = duibaHdtoolDto.getTitle();
                bannerImg = duibaHdtoolDto.getBannerImage();
                recImg = duibaHdtoolDto.getRecommendImage();
                iconImg = duibaHdtoolDto.getLogo();
                description = duibaHdtoolDto.getDescription();
                status = duibaHdtoolDto.getStatus();
                break;
            case DefinedActivityTypesDto.DUIBA_ACTIVITY: // 活动专题
                DuibaActivityDto duibaActivityDto = duibaActivityService.find(activityId);
                title = duibaActivityDto.getTitle();
                bannerImg = duibaActivityDto.getIndexBannerImage();
                recImg = duibaActivityDto.getRecommendImage();
                iconImg = duibaActivityDto.getLogo();
                description = duibaActivityDto.getSubtitle();
                status = duibaActivityDto.getStatus();
                break;
            case DefinedActivityTypesDto.SINGLE_LOTTERY:// 单品抽奖 3
                DuibaSingleLotteryDto duibaSingleLotteryDto = duibaSingleLotteryService.find(activityId);
                title = duibaSingleLotteryDto.getTitle();
                bannerImg = duibaSingleLotteryDto.getBannerImage();
                recImg = duibaSingleLotteryDto.getImage(); // TODO 无推荐图，使用默认图代替
                iconImg = duibaSingleLotteryDto.getLogo();
                description = duibaSingleLotteryDto.getSubtitle();
                status = duibaSingleLotteryDto.getStatus();
                break;
            case DefinedActivityTypesDto.SECONDS_KILL: // 秒杀专题 11
                DuibaSecondsKillActivityDto duibaSecondsKillActivityDto = duibaSecondsKillActivityService.find(activityId);
                title = duibaSecondsKillActivityDto.getTitle();
                bannerImg = duibaSecondsKillActivityDto.getIndexBannerImage();
                recImg = duibaSecondsKillActivityDto.getRecommendImage();
                iconImg = duibaSecondsKillActivityDto.getLogo();
                description = duibaSecondsKillActivityDto.getNextTitle();
                status = duibaSecondsKillActivityDto.getStatus();
                break;
            case DefinedActivityTypesDto.NGAME: // 新游戏 28
                DuibaNgameDto duibaNgameDto = duibaNgameService.find(activityId);
                title = duibaNgameDto.getTitle();
                bannerImg = duibaNgameDto.getBanner();
                recImg = duibaNgameDto.getRecommendImage();
                iconImg = duibaNgameDto.getLogo();
                description = ""; // TODO 没有描述
                status = duibaNgameDto.getGameStatus();
                break;
            case DefinedActivityTypesDto.QUESTION_ANSWER: // 答题30
                DuibaQuestionAnswerDto duibaQuestionAnswerDto = duibaQuestionAnswerService.find(activityId);
                title = duibaQuestionAnswerDto.getTitle();
                bannerImg = duibaQuestionAnswerDto.getBanner();
                recImg = duibaQuestionAnswerDto.getRecommendImage();
                iconImg = duibaQuestionAnswerDto.getLogo();
                description = ""; // TODO 没有描述
                status = duibaQuestionAnswerDto.getStatus();
                break;
            case DefinedActivityTypesDto.DUIBA_SEC_KILL:// 秒杀活动 40
                DuibaSeckillDO duibaSeckillDO = duibaSeckillService.find(activityId);
                title = duibaSeckillDO.getTitle();
                bannerImg = duibaSeckillDO.getBanner();
                recImg = duibaSeckillDO.getRecommendImage();
                iconImg = duibaSeckillDO.getLogo();
                description = ""; // TODO 没有描述
                status = duibaSeckillDO.getStatus();
                break;
            case DefinedActivityTypesDto.QUIZZ: // 测试题 41
                DuibaQuizzDto duibaQuizzDto = duibaQuizzService.find(activityId);
                title = duibaQuizzDto.getTitle();
                bannerImg = duibaQuizzDto.getBanner();
                recImg = duibaQuizzDto.getRecommendImage();
                iconImg = duibaQuizzDto.getLogo();
                description = ""; // TODO 没有描述
                status = duibaQuizzDto.getStatus();
                break;
            case DefinedActivityTypesDto.GUESS: // 竞猜 42
                DuibaGuessDto duibaGuessDto = duibaGuessService.find(activityId);
                title = duibaGuessDto.getTitle();
                bannerImg = duibaGuessDto.getBanner();
                recImg = duibaGuessDto.getRecommendImage();
                iconImg = duibaGuessDto.getLogo();
                description = ""; // TODO 没有描述
                status = duibaGuessDto.getStatus();
                break;
            default:
                throw new GameCenterException("Activity type not support: " + activityType.intValue());
        }
        GeneralActivityItem result = new GeneralActivityItem();
        result.setActivityId(activityId);
        result.setActivityType(activityType);
        result.setTitle(title);
        result.setBannerImg(bannerImg);
        result.setRecommendImg(recImg);
        result.setIconImg(iconImg);
        result.setDescription(description);
        result.setStatus(status);
        return result;
    }

    @Override
    public List<GeneralActivityItem> findActivityByType(Integer activityType, Integer offset,
                                                        Integer max) throws GameCenterException {

        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("offset", offset);
        paramMap.put("max", max);
        List<GeneralActivityItem> result = new ArrayList<GeneralActivityItem>();
        GeneralActivityItem item;
        switch (activityType.intValue()) {
            case DefinedActivityTypesDto.NEW_HDTOOL: // 新活动工具
                List<DuibaHdtoolDto> duibaHdtoolDtoList = duibaHdtoolService.findDuibaHdToolsList(paramMap);
                if (CollectionUtils.isEmpty(duibaHdtoolDtoList)) {
                    return Collections.emptyList();
                }
                for (DuibaHdtoolDto duibaHdtoolDto : duibaHdtoolDtoList) {
                    item = new GeneralActivityItem();
                    item.setActivityId(duibaHdtoolDto.getId());
                    item.setActivityType(activityType);
                    item.setTitle(duibaHdtoolDto.getTitle());
                    item.setBannerImg(duibaHdtoolDto.getBannerImage());
                    item.setRecommendImg(duibaHdtoolDto.getRecommendImage());
                    item.setIconImg(duibaHdtoolDto.getLogo());
                    item.setDescription(duibaHdtoolDto.getDescription());
                    item.setStatus(duibaHdtoolDto.getStatus());
                    result.add(item);
                }
                break;
            case DefinedActivityTypesDto.DUIBA_ACTIVITY: // 活动专题
                List<DuibaActivityDto> duibaActivityDtoList = duibaActivityService.findPage(paramMap);
                if (CollectionUtils.isEmpty(duibaActivityDtoList)) {
                    return Collections.emptyList();
                }
                for (DuibaActivityDto duibaActivityDto : duibaActivityDtoList) {
                    item = new GeneralActivityItem();
                    item.setActivityId(duibaActivityDto.getId());
                    item.setActivityType(activityType);
                    item.setTitle(duibaActivityDto.getTitle());
                    item.setBannerImg(duibaActivityDto.getIndexBannerImage());
                    item.setRecommendImg(duibaActivityDto.getRecommendImage());
                    item.setIconImg(duibaActivityDto.getLogo());
                    item.setDescription(duibaActivityDto.getSubtitle());
                    item.setStatus(duibaActivityDto.getStatus());
                    result.add(item);
                }
                break;
            case DefinedActivityTypesDto.SINGLE_LOTTERY:// 单品抽奖 3
                List<DuibaSingleLotteryDto> duibaSingleLotteryDtoList = duibaSingleLotteryService.findSingleLotteryPage(paramMap);
                if (CollectionUtils.isEmpty(duibaSingleLotteryDtoList)) {
                    return Collections.emptyList();
                }
                for (DuibaSingleLotteryDto duibaSingleLotteryDto : duibaSingleLotteryDtoList) {
                    item = new GeneralActivityItem();
                    item.setActivityId(duibaSingleLotteryDto.getId());
                    item.setActivityType(activityType);
                    item.setTitle(duibaSingleLotteryDto.getTitle());
                    item.setBannerImg(duibaSingleLotteryDto.getBannerImage());
                    item.setRecommendImg(duibaSingleLotteryDto.getImage());// TODO 无推荐图，使用默认图代替
                    item.setIconImg(duibaSingleLotteryDto.getLogo());
                    item.setDescription(duibaSingleLotteryDto.getSubtitle());
                    item.setStatus(duibaSingleLotteryDto.getStatus());
                    result.add(item);
                }
                break;
            case DefinedActivityTypesDto.SECONDS_KILL: // 秒杀专题 11
                List<DuibaSecondsKillActivityDto> duibaSecondsKillActivityDtoList = duibaSecondsKillActivityService.findByPage(paramMap);
                if (CollectionUtils.isEmpty(duibaSecondsKillActivityDtoList)) {
                    return Collections.emptyList();
                }
                for (DuibaSecondsKillActivityDto duibaSecondsKillActivityDto : duibaSecondsKillActivityDtoList) {
                    item = new GeneralActivityItem();
                    item.setActivityId(duibaSecondsKillActivityDto.getId());
                    item.setActivityType(activityType);
                    item.setTitle(duibaSecondsKillActivityDto.getTitle());
                    item.setBannerImg(duibaSecondsKillActivityDto.getIndexBannerImage());
                    item.setRecommendImg(duibaSecondsKillActivityDto.getRecommendImage());
                    item.setIconImg(duibaSecondsKillActivityDto.getLogo());
                    item.setDescription(duibaSecondsKillActivityDto.getNextTitle());
                    item.setStatus(duibaSecondsKillActivityDto.getStatus());
                    result.add(item);
                }
                break;
            case DefinedActivityTypesDto.NGAME: // 新游戏 28
                List<DuibaNgameDto> duibaNgameDtoList = duibaNgameService.findByPage(offset, max, null, null);
                if (CollectionUtils.isEmpty(duibaNgameDtoList)) {
                    return Collections.emptyList();
                }
                for (DuibaNgameDto duibaNgameDto : duibaNgameDtoList) {
                    item = new GeneralActivityItem();
                    item.setActivityId(duibaNgameDto.getId());
                    item.setActivityType(activityType);
                    item.setTitle(duibaNgameDto.getTitle());
                    item.setBannerImg(duibaNgameDto.getBanner());
                    item.setRecommendImg(duibaNgameDto.getRecommendImage());
                    item.setIconImg(duibaNgameDto.getLogo());
                    item.setDescription("");// TODO 没有描述
                    item.setStatus(duibaNgameDto.getGameStatus());
                    result.add(item);
                }
                break;
            case DefinedActivityTypesDto.QUESTION_ANSWER: // 答题30
                List<DuibaQuestionAnswerDto> duibaQuestionAnswerDtoList = duibaQuestionAnswerService.findByPage(paramMap);
                if (CollectionUtils.isEmpty(duibaQuestionAnswerDtoList)) {
                    return Collections.emptyList();
                }

                for (DuibaQuestionAnswerDto duibaQuestionAnswerDto : duibaQuestionAnswerDtoList) {
                    item = new GeneralActivityItem();
                    item.setActivityId(duibaQuestionAnswerDto.getId());
                    item.setActivityType(activityType);
                    item.setTitle(duibaQuestionAnswerDto.getTitle());
                    item.setBannerImg(duibaQuestionAnswerDto.getBanner());
                    item.setRecommendImg(duibaQuestionAnswerDto.getRecommendImage());
                    item.setIconImg(duibaQuestionAnswerDto.getLogo());
                    item.setDescription("");// TODO 没有描述
                    item.setStatus(duibaQuestionAnswerDto.getStatus());
                    result.add(item);
                }
                break;
            case DefinedActivityTypesDto.DUIBA_SEC_KILL:// 秒杀活动 40
                List<DuibaSeckillDO> duibaSeckillDOList = duibaSeckillService.findByPage(paramMap);
                if (CollectionUtils.isEmpty(duibaSeckillDOList)) {
                    return Collections.emptyList();
                }

                for (DuibaSeckillDO duibaSeckillDO : duibaSeckillDOList) {
                    item = new GeneralActivityItem();
                    item.setActivityId(duibaSeckillDO.getId());
                    item.setActivityType(activityType);
                    item.setTitle(duibaSeckillDO.getTitle());
                    item.setBannerImg(duibaSeckillDO.getBanner());
                    item.setRecommendImg(duibaSeckillDO.getRecommendImage());
                    item.setIconImg(duibaSeckillDO.getLogo());
                    item.setDescription("");// TODO 没有描述
                    item.setStatus(duibaSeckillDO.getStatus());
                    result.add(item);
                }
                break;
            case DefinedActivityTypesDto.QUIZZ: // 测试题 41
                List<DuibaQuizzDto> duibaQuizzDtoList = duibaQuizzService.findByPage(paramMap);
                if (CollectionUtils.isEmpty(duibaQuizzDtoList)) {
                    return Collections.emptyList();
                }

                for (DuibaQuizzDto duibaQuizzDto : duibaQuizzDtoList) {
                    item = new GeneralActivityItem();
                    item.setActivityId(duibaQuizzDto.getId());
                    item.setActivityType(activityType);
                    item.setTitle(duibaQuizzDto.getTitle());
                    item.setBannerImg(duibaQuizzDto.getBanner());
                    item.setRecommendImg(duibaQuizzDto.getRecommendImage());
                    item.setIconImg(duibaQuizzDto.getLogo());
                    item.setDescription("");// TODO 没有描述
                    item.setStatus(duibaQuizzDto.getStatus());
                    result.add(item);
                }
                break;
            case DefinedActivityTypesDto.GUESS: // 竞猜 42
                List<DuibaGuessDto> duibaGuessDtoList = duibaGuessService.findByPage(offset, max, null, null);
                if (CollectionUtils.isEmpty(duibaGuessDtoList)) {
                    return Collections.emptyList();
                }
                for (DuibaGuessDto duibaGuessDto : duibaGuessDtoList) {
                    item = new GeneralActivityItem();
                    item.setActivityId(duibaGuessDto.getId());
                    item.setActivityType(activityType);
                    item.setTitle(duibaGuessDto.getTitle());
                    item.setBannerImg(duibaGuessDto.getBanner());
                    item.setRecommendImg(duibaGuessDto.getRecommendImage());
                    item.setIconImg(duibaGuessDto.getLogo());
                    item.setDescription("");// TODO 没有描述
                    item.setStatus(duibaGuessDto.getStatus());
                    result.add(item);
                }
                break;
            default:
                throw new GameCenterException("Activity type not support: " + activityType.intValue());
        }
        return result;
    }

    @Override
    public Integer countActivityByType(Integer activityType) throws GameCenterException {
        Integer result;
        Map<String, Object> paramMap = new HashMap<String, Object>();
        switch (activityType.intValue()) {
            case DefinedActivityTypesDto.NEW_HDTOOL: // 新活动工具
                // 过滤新活动工具
                paramMap.put("newHdtool", Boolean.TRUE);
                result = duibaHdtoolService.countDuibaHdToolsList(paramMap);
                break;
            case DefinedActivityTypesDto.DUIBA_ACTIVITY: // 活动专题
                result = duibaActivityService.findPageCount(paramMap);
                break;
            case DefinedActivityTypesDto.SINGLE_LOTTERY:// 单品抽奖 3
                result = duibaSingleLotteryService.findSingleLotteryPageCount(paramMap).intValue(); // 转成int
                break;
            case DefinedActivityTypesDto.SECONDS_KILL: // 秒杀专题 11
                result = duibaSecondsKillActivityService.count(paramMap);
                break;
            case DefinedActivityTypesDto.NGAME: // 新游戏 28
                result = duibaNgameService.findByPageCount(null, null).intValue(); // 转成int
                break;
            case DefinedActivityTypesDto.QUESTION_ANSWER: // 答题30
                result = duibaQuestionAnswerService.findPageCount(paramMap).intValue(); // 转成int
                break;
            case DefinedActivityTypesDto.DUIBA_SEC_KILL:// 秒杀活动 40
                result = duibaSeckillService.findPageCount(paramMap).intValue(); // 转成int
                break;
            case DefinedActivityTypesDto.QUIZZ: // 测试题 41
                result = duibaQuizzService.findPageCount(paramMap).intValue(); // 转成int
                break;
            case DefinedActivityTypesDto.GUESS: // 竞猜 42
                result = duibaGuessService.findPageCount(null, null).intValue();// 转成int
                break;
            default:
                throw new GameCenterException("Activity type not support: " + activityType.intValue());
        }
        return result;
    }
}
