/**
 * Project Name:activity-center-biz
 * File Name:GameSkinService.java
 * Package Name:cn.com.duiba.activity.center.biz.service.gameskin
 * Date:2016年9月29日下午7:23:07
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.service.gameskin;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.gameskin.GameSkinDto;
import cn.com.duiba.activity.center.biz.entity.gameskin.GameSkinEntity;

/**
 * ClassName:GameSkinService <br/>
 * Date:     2016年9月29日 下午7:23:07 <br/>
 * @author   wubo
 * @version  
 * @see 	 
 */
public interface GameSkinService {
    /**
     * selectById:根据id查询. <br/>
     * @author wubo
     * @param id
     * @return
     */
    GameSkinEntity selectById(Long id);
    /**
     * insert:添加. <br/>
     *
     * @author wubo
     * @param entity
     * @return
     */
    Long insert(GameSkinEntity entity);
    /**
     * update:更新. <br/>
     *
     * @author wubo
     * @param entity
     * @return
     */
    Long update(GameSkinEntity entity);
    /**
     * selectByPage:分页查询，管理端展示用. <br/>
     *
     * @author wubo
     * @param offset
     * @param max
     * @return
     */
    List<GameSkinEntity> selectByPage(int offset,int max);
    /**
     * selectCount:计数. <br/>
     * @author wubo
     * @param name 皮肤名称，可为空
     * @return
     */
    Long selectCount(String name);
    
    /**
     * selectByType:根据类型查询. <br/>
     * @author wubo
     * @param type
     * @return
     */
    List<GameSkinEntity> selectByType(Byte type);
    
    /**
     * describe : 根据皮肤ID查询皮肤
     * @author  : cdm
     * @date    : 2016年10月18日下午5:33:13
     * @param id  皮肤ID
     */
    String getBrickContentById(final Long id);
    
    /**
     * describe : 查询不带皮肤内容的皮肤实体
     * @author  : cdm
     * @date    : 2016年10月18日下午5:40:59
     * @param id 皮肤ID
     */
    GameSkinDto findNoContent(final Long id);
}

