/**
 * Project Name:activity-center-biz
 * File Name:GameSkinServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.service.gameskin.impl
 * Date:2016年9月29日下午7:28:10
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.service.gameskin.impl;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;
import cn.com.duiba.activity.center.api.dto.gameskin.GameSkinDto;
import cn.com.duiba.activity.center.biz.dao.gameskin.GameSkinDao;
import cn.com.duiba.activity.center.biz.entity.gameskin.GameSkinEntity;
import cn.com.duiba.activity.center.biz.service.gameskin.GameSkinService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * ClassName:GameSkinServiceImpl <br/>
 * Date:     2016年9月29日 下午7:28:10 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository
public class GameSkinServiceImpl implements GameSkinService{

    @Resource
    private GameSkinDao gameSkinDao;
    @Resource
    private CacheClient cacheClient;
    
    @Override
    public GameSkinEntity selectById(Long id) {
        return gameSkinDao.selectById(id);
    }

    @Override
    public Long insert(GameSkinEntity entity) {
        return gameSkinDao.insert(entity);
    }

    @Override
    public Long update(GameSkinEntity entity) {
        return this.gameSkinDao.update(entity);
    }

    @Override
    public List<GameSkinEntity> selectByPage(int offset, int max) {
        return this.gameSkinDao.selectByPage(offset, max);
    }

    @Override
    public Long selectCount(String name) {
        return this.gameSkinDao.selectCount(name);
    }

    @Override
    public List<GameSkinEntity> selectByType(Byte type) {
        return this.gameSkinDao.selectByType(type);
    }
    
    
    @Override
    public String getBrickContentById(final Long id) {
        return cacheClient.getWithCacheLoader(getContentCacheKeyById(id), 1, TimeUnit.HOURS, new CacheLoader<String>() {
            @Override
            public String load() {
                return gameSkinDao.getBrickContentById(id);
            }
        });
    }

    private String getNoContentCacheKeyById(Long id){
        return CacheConstants.KEY_DUIBA_NGAMR_BRICK_NO_CONTENT_BY_ID + id;
    }

    private String getContentCacheKeyById(Long id){
        return CacheConstants.KEY_DUIBA_NGAMR_BRICK_CONTENT_BY_ID + id;
    }

    @Override
    public GameSkinDto findNoContent(final Long id) {
        return cacheClient.getWithCacheLoader(getNoContentCacheKeyById(id), 20, TimeUnit.MINUTES, new CacheLoader<GameSkinDto>() {
            @Override
            public GameSkinDto load() {
                return BeanUtils.copy(gameSkinDao.findNoContent(id), GameSkinDto.class);
            }
        });
    }

}

