package cn.com.duiba.activity.center.biz.service.guess.impl;

import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessStockManualChangeDto;
import cn.com.duiba.activity.center.biz.dao.guess.DuibaGuessStockManualChangeDao;
import cn.com.duiba.activity.center.biz.entity.guess.DuibaGuessStockManualChangeEntity;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessStockManualChangeService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/7/26.
 */
@Service
public class DuibaGuessStockManualChangeServiceImpl implements DuibaGuessStockManualChangeService {

    @Autowired
    private DuibaGuessStockManualChangeDao duibaGuessStockManualChangeDao;
    @Override
    public List<DuibaGuessStockManualChangeDto> findByStockId(Long guessStockId) {
        return BeanUtils.copyList(duibaGuessStockManualChangeDao.findByStockId(guessStockId),DuibaGuessStockManualChangeDto.class);
    }

    @Override
    public List<DuibaGuessStockManualChangeDto> addBatch(List<DuibaGuessStockManualChangeDto> list) {
    	List<DuibaGuessStockManualChangeEntity> listEntity = BeanUtils.copyList(list,DuibaGuessStockManualChangeEntity.class);
        duibaGuessStockManualChangeDao.addBatch(listEntity);
        return BeanUtils.copyList(listEntity, DuibaGuessStockManualChangeDto.class);
    }

    @Override
    public void add(DuibaGuessStockManualChangeDto guessStockManualChangeDO) {
        DuibaGuessStockManualChangeEntity entity=BeanUtils.copy(guessStockManualChangeDO,DuibaGuessStockManualChangeEntity.class);
        duibaGuessStockManualChangeDao.add(entity);
        guessStockManualChangeDO.setId(entity.getId());
    }

}
