package cn.com.duiba.activity.center.biz.support;

import java.net.InetAddress;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by xuezhaoming on 16/5/23.
 */
public final class NetHelper {

    private static Logger log = LoggerFactory.getLogger(NetHelper.class);
    private static String ip;

    /**
     * 获取本机器地址
     * 
     * @return
     */
    public static String getLocalHostIP() {

        if (ip != null) {
            return ip;
        }

        synchronized (NetHelper.class) {
            try {
                /** 返回本地主机。 */
                InetAddress addr = InetAddress.getLocalHost();
                /** 返回 IP 地址字符串（以文本表现形式） */
                ip = addr.getHostAddress();
            } catch (Exception ex) {
                log.error("error:",ex);
                ip = "";
            }
        }

        return ip;
    }
}
