/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.activity;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.enums.DuibaActivityTypeEnum;
import cn.com.duiba.activity.center.api.remoteservice.activity.RemoteActivityService;
import cn.com.duiba.activity.center.biz.service.commonactivity.ActivityToolService;
import cn.com.duiba.dcommons.domain.Tuple;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteActivityService")
public class RemoteActivityServiceImpl
implements RemoteActivityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteActivityServiceImpl.class);
    @Autowired
    private ActivityToolService activityToolService;

    public DubboResult<OperatingActivityDto> getOperatingActivityDto(Long appId, Long activityId, Integer type) {
        try {
            OperatingActivityDto result = this.activityToolService.findAppActivity(appId, activityId, type);
            return DubboResult.successResult((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("getOperatingActivityDto error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<OperatingActivityDto>> getOperatingActivityDtos(Long appId, List<Tuple.Tuple2<Integer, Long>> activities) {
        try {
            List<OperatingActivityDto> dtos = this.activityToolService.findAppActivitys(appId, activities);
            return DubboResult.successResult(dtos);
        }
        catch (Exception e) {
            LOGGER.error("getOperatingActivityDtos error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Map<Long, String>> getUrlMap(List<Tuple.Tuple2<Integer, Long>> activities) {
        try {
            Map<Long, String> result = this.activityToolService.getMobileUrlMap(activities);
            return DubboResult.successResult(result);
        }
        catch (Exception e) {
            LOGGER.error("getUrlMap error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<String> getTitle(Long duibaActivityId, DuibaActivityTypeEnum typeEnum) {
        try {
            String title = this.activityToolService.getTitle(duibaActivityId, typeEnum);
            return DubboResult.successResult((Object)title);
        }
        catch (Exception e) {
            LOGGER.error("getTitle error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

