/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.asynctask.impl;

import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.activity.center.biz.service.asynctask.OperatingActivityAsyncTaskService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperatingActivityAsyncTaskServiceImpl
implements OperatingActivityAsyncTaskService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(OperatingActivityAsyncTaskServiceImpl.class);
    @Autowired
    private OperatingActivityService operatingActivityService;
    private Map<Long, AtomicInteger> countJoinNum = new ConcurrentHashMap<Long, AtomicInteger>();
    private ScheduledExecutorService scheduled = Executors.newScheduledThreadPool(1, new ThreadFactory(){
        private int i = 0;

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "Thread-ActivityJoinNum-" + this.i++);
        }
    });

    public void afterPropertiesSet() throws Exception {
        this.scheduled.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    for (Map.Entry entry : OperatingActivityAsyncTaskServiceImpl.this.countJoinNum.entrySet()) {
                        if (((AtomicInteger)entry.getValue()).intValue() <= 0) continue;
                        long operatingActivityId = (Long)entry.getKey();
                        int count = ((AtomicInteger)entry.getValue()).intValue();
                        OperatingActivityAsyncTaskServiceImpl.this.countJoinNum.put(operatingActivityId, new AtomicInteger(0));
                        OperatingActivityAsyncTaskServiceImpl.this.operatingActivityService.updateVisitTimes(operatingActivityId, count);
                    }
                }
                catch (Exception e) {
                    log.error("updateJoinNum:", (Throwable)e);
                }
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void increaseJoinNum(Long operatingActivityId) {
        AtomicInteger count = this.countJoinNum.get(operatingActivityId);
        if (count == null) {
            count = new AtomicInteger(1);
        } else {
            count.incrementAndGet();
        }
        this.countJoinNum.put(operatingActivityId, count);
    }
}

