/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.sign.impl;

import cn.com.duiba.activity.center.api.dto.sign.SignConfigDto;
import cn.com.duiba.activity.center.biz.dao.sign.SignConfigDao;
import cn.com.duiba.activity.center.biz.entity.sign.SignConfigEntity;
import cn.com.duiba.activity.center.biz.service.sign.SignConfigService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SignConfigServiceImpl
implements SignConfigService {
    @Resource
    private SignConfigDao signConfigDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "activity-signConfigById_" + id;
    }

    @Override
    public List<SignConfigDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(this.signConfigDao.findAllByIds(ids), SignConfigDto.class);
    }

    @Override
    public List<SignConfigDto> findByPage(Long appId, Integer offset, Integer max, String title, Integer id) {
        return BeanUtils.copyList(this.signConfigDao.findByPage(appId, offset, max, title, id), SignConfigDto.class);
    }

    @Override
    public Long findByPageCount(Long appId, String title, Integer id) {
        return this.signConfigDao.findByPageCount(appId, title, id);
    }

    @Override
    public SignConfigDto find(final Long id) {
        return (SignConfigDto)this.cacheClient.getWithCacheLoader(this.getCacheKeyById(id), 30, TimeUnit.MINUTES, (CacheLoader)new CacheLoader<SignConfigDto>(){

            public SignConfigDto load() {
                return (SignConfigDto)BeanUtils.copy((Object)SignConfigServiceImpl.this.signConfigDao.find(id), SignConfigDto.class);
            }
        });
    }

    @Override
    public void add(SignConfigDto sign) {
        SignConfigEntity e = (SignConfigEntity)BeanUtils.copy((Object)sign, SignConfigEntity.class);
        this.signConfigDao.add(e);
        sign.setId(e.getId());
    }

    @Override
    public void delete(Long id) {
        this.signConfigDao.delete(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public void update(SignConfigDto sign) {
        SignConfigEntity e = (SignConfigEntity)BeanUtils.copy((Object)sign, SignConfigEntity.class);
        this.signConfigDao.update(e);
        this.cacheClient.remove(this.getCacheKeyById(sign.getId()));
    }

    @Override
    public int updateStatus(Long id, Integer status) {
        int ret = this.signConfigDao.updateStatus(id, status);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }
}

