/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.tools;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.KeyProvider;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.command.KestrelCommandFactory;
import net.rubyeye.xmemcached.command.TextCommandFactory;
import net.rubyeye.xmemcached.transcoders.SerializingTranscoder;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class XMemCacheClient
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(XMemCacheClient.class);
    private MemcachedClient memcachedClient;
    private final String CACHE_NAME = XMemCacheClient.class.getName();
    private String servers;
    private String authInfos;
    private String username;
    private String password;
    private MemcachedSessionLocator sessionLocator;
    private String protocol;
    private int connectionPoolSize;
    private int connectionTimeout = 60000;
    private int operationTimeout = 1000;
    private boolean enableHeartBeat;

    public String getServers() {
        return this.servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public String getAuthInfos() {
        return this.authInfos;
    }

    public void setAuthInfos(String authInfos) {
        this.authInfos = authInfos;
    }

    private void initClient() {
        if (this.memcachedClient != null) {
            logger.info(this.CACHE_NAME + " already initialized");
            return;
        }
        String[] servers = StringUtils.split((String)this.getServers(), (String)",");
        String[] authInfos = StringUtils.split((String)this.getAuthInfos(), (String)",");
        ArrayList<InetSocketAddress> addressList = new ArrayList<InetSocketAddress>();
        HashMap<InetSocketAddress, AuthInfo> authInfoMap = new HashMap<InetSocketAddress, AuthInfo>();
        int i = 0;
        for (String server : servers) {
            InetSocketAddress address = AddrUtil.getOneAddress((String)server);
            addressList.add(address);
            if (authInfos != null && authInfos.length > 0) {
                String authInfo;
                String[] temp;
                if (authInfos != null && authInfos.length > i && (temp = (authInfo = authInfos[i]).split(":")).length >= 1) {
                    authInfoMap.put(address, AuthInfo.plain((String)temp[0], (String)temp[1]));
                    logger.info("auth " + server + " with username:" + temp[0] + ",password:" + temp[1]);
                }
            } else if (!StringUtils.isBlank((String)this.username) && !StringUtils.isBlank((String)this.password)) {
                authInfoMap.put(address, AuthInfo.plain((String)this.username, (String)this.password));
            }
            ++i;
        }
        XMemcachedClientBuilder builder = new XMemcachedClientBuilder(addressList);
        builder.setAuthInfoMap(authInfoMap);
        if (this.sessionLocator != null) {
            builder.setSessionLocator(this.sessionLocator);
        }
        SerializingTranscoder transcoder = new SerializingTranscoder();
        transcoder.setCompressionThreshold(1024);
        builder.setTranscoder((Transcoder)transcoder);
        if (StringUtils.isBlank((String)this.protocol) || this.protocol.equals("BINARY")) {
            builder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
        } else if (this.protocol.equals("TEXT")) {
            builder.setCommandFactory((CommandFactory)new TextCommandFactory());
        } else if (this.protocol.equals("KESTREL")) {
            builder.setCommandFactory((CommandFactory)new KestrelCommandFactory());
        }
        builder.setKeyProvider(new KeyProvider(){

            public String process(String key) {
                if (key == null) {
                    return null;
                }
                return key.trim();
            }
        });
        builder.setHealSessionInterval(2000L);
        if (this.connectionPoolSize > 0) {
            builder.setConnectionPoolSize(this.connectionPoolSize);
        }
        try {
            this.memcachedClient = builder.build();
            this.memcachedClient.setConnectTimeout((long)this.connectionTimeout);
            this.memcachedClient.setOpTimeout((long)this.operationTimeout);
            this.memcachedClient.setEnableHeartBeat(this.enableHeartBeat);
            logger.info(addressList + " initialized{}");
        }
        catch (IOException e) {
            logger.error("Initialize " + this.getClass() + " error", (Throwable)e);
            throw new RuntimeException("Initialize " + this.getClass() + " error", e);
        }
        try {
            Field field = this.memcachedClient.getClass().getDeclaredField("shutdownHookThread");
            field.setAccessible(true);
            Thread shutdownHookThread = (Thread)field.get(this.memcachedClient);
            Runtime.getRuntime().removeShutdownHook(shutdownHookThread);
        }
        catch (Exception e) {
            logger.error("warn: getField:shutdownHookThread error", (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.initClient();
    }

    public MemcachedClient getMemcachedClient() {
        return this.memcachedClient;
    }

    public void setMemcachedClient(MemcachedClient memcachedClient) {
        this.memcachedClient = memcachedClient;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public MemcachedSessionLocator getSessionLocator() {
        return this.sessionLocator;
    }

    public void setSessionLocator(MemcachedSessionLocator sessionLocator) {
        this.sessionLocator = sessionLocator;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public boolean isEnableHeartBeat() {
        return this.enableHeartBeat;
    }

    public void setEnableHeartBeat(boolean enableHeartBeat) {
        this.enableHeartBeat = enableHeartBeat;
    }
}

