package cn.com.duiba.activity.center.biz.bo.stock;

import cn.com.duiba.activity.center.api.dto.singlelottery.*;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.service.singlelottery.DuibaSingleLotteryService;
import cn.com.duiba.activity.center.biz.service.singlelottery.SingleLotteryService;
import cn.com.duiba.activity.center.biz.service.singlelottery.SingleLotteryStockConsumeService;
import cn.com.duiba.service.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service
public class SingleLotteryStockConsumeBo {

	private static Logger log = LoggerFactory.getLogger(SingleLotteryStockConsumeBo.class);
	@Autowired
	private DuibaSingleLotteryService duibaSingleLotteryService;
	@Autowired
	private SingleLotteryStockConsumeService singleLotteryStockConsumeService;
	@Autowired
	private SingleLotteryService singleLotteryService;
	
	@Transactional(value = DsConstants.DATABASE_CREDITS)
	public void consumeDuibaSingleLotteryStock(Long duibaSingleLotteryId,
			Long appId, Integer optionType,String bizId,String bizSource) throws BusinessException {
		
		String optionTypeStr = null;
		
		//锁
		DuibaSingleLotteryDto duibaSingle = duibaSingleLotteryService.findForupdate(duibaSingleLotteryId);
		if(null == duibaSingle){
			throw new BusinessException("不存在的单品抽奖");
		}
		//大奖
		if(optionType == SingleLotteryOrderDto.OptionTypeBig){
			if(duibaSingle.getMainItemRemaining() <= 0){
				throw new BusinessException("大奖库存不足");
			}
			int ret = duibaSingleLotteryService.reduceMainItemRemaining(duibaSingle.getId());
			if(ret < 1){
				throw new BusinessException("抽奖失败，更新大奖剩余数量异常");
			}
			optionTypeStr = SingleLotteryStockConsumeDto.OPTION_MAIN;
		}
		//小奖
		else if(optionType == SingleLotteryOrderDto.OptionTypeSmall){
			if(duibaSingle.getInciteItemRemaining() <= 0){
				throw new BusinessException("小奖库存不足");
			}
			int ret = duibaSingleLotteryService.reduceInciteItemRemaining(duibaSingle.getId());
			if(ret < 1){
				throw new BusinessException("抽奖失败，更新小奖剩余数量异常");
			}
			optionTypeStr = SingleLotteryStockConsumeDto.OPTION_INCITE;
		}
		Date now = new Date(System.currentTimeMillis()/1000*1000);

		SingleLotteryStockConsumeDto consume = new SingleLotteryStockConsumeDto(true);
		consume.setRelationId(duibaSingle.getId());//对于单品抽奖取单品id
		consume.setRelationType(SingleLotteryStockConsumeDto.TYPE_DUIBA);
		consume.setAppId(appId);
		consume.setAction(SingleLotteryStockConsumeDto.ACTION_PAY);
		consume.setBizId(bizId);
		consume.setOptionType(optionTypeStr);
		consume.setBizSource(bizSource);
		consume.setQuantity(1L);
		consume.setGmtCreate(now);
		consume.setGmtModified(now);

		singleLotteryStockConsumeService.insert(consume);
	}

	@Transactional(value = DsConstants.DATABASE_CREDITS)
	public void paybackDuibaSingleLotteryStock(String bizId,String bizSource) throws BusinessException {
		
		SingleLotteryStockConsumeDto consume = singleLotteryStockConsumeService.findByBizIdAndSource(bizId, bizSource);
		
		if(null == consume){
			log.error("记录不存在");
			return;
		}
		//锁
		DuibaSingleLotteryDto duibaSingle = duibaSingleLotteryService.findForupdate(consume.getRelationId());

		if(null == duibaSingle){
			log.error("记录不存在");
			return;
		}
		//大奖
		if(consume.getOptionType().equals(SingleLotteryStockConsumeDto.OPTION_MAIN)){

			int ret = duibaSingleLotteryService.addMainItemRemaining(duibaSingle.getId());
			if(ret < 1){
				throw new BusinessException("返大奖剩余数量异常");
			}
		}
		//小奖
		else if(consume.getOptionType().equals(SingleLotteryStockConsumeDto.OPTION_INCITE)){

			int ret = duibaSingleLotteryService.addInciteItemRemaining(duibaSingle.getId());
			if(ret < 1){
				throw new BusinessException("返小奖剩余数量异常");
			}
		}
		Date now = new Date(System.currentTimeMillis()/1000*1000);

		SingleLotteryStockConsumeDto detail = new SingleLotteryStockConsumeDto(true);
		detail.setRelationId(consume.getRelationId());
		detail.setRelationType(consume.getRelationType());
		detail.setAppId(consume.getAppId());
		detail.setAction(SingleLotteryStockConsumeDto.ACTION_BACK);
		detail.setBizId(consume.getBizId());
		detail.setBizSource(consume.getBizSource());
		detail.setOptionType(consume.getOptionType());
		detail.setQuantity(1L);
		detail.setGmtCreate(now);
		detail.setGmtModified(now);

		singleLotteryStockConsumeService.insert(detail);
	}

	@Transactional(value = DsConstants.DATABASE_CREDITS)
	public void consumeSingleLotterySpecifyStock(Long duibaSingleLotteryId,
			Long appId, String bizId,String bizSource) throws BusinessException {
		
		SingleLotteryAppSpecifyDto specify = duibaSingleLotteryService.findSpecifyByDuibaSingleLotteryAndApp(duibaSingleLotteryId, appId);
		if(null == specify){
			throw new BusinessException("无定向关系");
		}
		
		//锁
		specify = duibaSingleLotteryService.findSpecifyForupdate(specify.getId());
		if(specify.getRemaining() <= 0){
			throw new BusinessException("单品定向库存不足");
		}
		int ret = duibaSingleLotteryService.reduceSpecifyAppRemaining(duibaSingleLotteryId,appId);
		if(ret < 1){
			throw new BusinessException("更新单品抽奖定向分配数量异常");
		}
		Date now = new Date(System.currentTimeMillis()/1000*1000);

		SingleLotteryStockConsumeDto consume = new SingleLotteryStockConsumeDto(true);
		consume.setRelationId(specify.getId());//定向表id
		consume.setRelationType(SingleLotteryStockConsumeDto.BIZ_SOURCE_SPECIFY);//单品定向类型
		consume.setAppId(appId);
		consume.setAction(SingleLotteryStockConsumeDto.ACTION_PAY);
		consume.setBizId(bizId);
		consume.setOptionType(SingleLotteryStockConsumeDto.OPTION_MAIN);
		consume.setBizSource(bizSource);
		consume.setQuantity(1L);
		consume.setGmtCreate(now);
		consume.setGmtModified(now);

		singleLotteryStockConsumeService.insert(consume);
	}

	@Transactional(value = DsConstants.DATABASE_CREDITS)
	public void paybackSingleLotterySpecifyStock(String bizId,String bizSource) throws BusinessException {
		
		SingleLotteryStockConsumeDto consume = singleLotteryStockConsumeService.findByBizIdAndSource(bizId, bizSource);
		
		if(null == consume){
			log.error("无消费记录");
			return;
		}
		
		//锁
		SingleLotteryAppSpecifyDto specify = duibaSingleLotteryService.findSpecifyForupdate(consume.getRelationId());
		if(null == specify){
			log.error("无定向记录");
			return;
		}

		int ret = duibaSingleLotteryService.addSpecifyAppRemaining(specify.getDuibaSingleLotteryId(),specify.getAppId());
		if(ret < 1){
			throw new BusinessException("更新单品抽奖定向分配数量异常");
		}
		Date now = new Date(System.currentTimeMillis()/1000*1000);

		SingleLotteryStockConsumeDto detail = new SingleLotteryStockConsumeDto(true);
		detail.setRelationId(specify.getId());//定向表id
		detail.setRelationType(consume.getRelationType());//单品定向类型
		detail.setAppId(specify.getAppId());
		detail.setAction(SingleLotteryStockConsumeDto.ACTION_BACK);
		detail.setBizId(bizId);//抽奖订单id
		detail.setOptionType(consume.getOptionType());
		detail.setBizSource(consume.getBizSource());
		detail.setQuantity(1L);
		detail.setGmtCreate(now);
		detail.setGmtModified(now);

		singleLotteryStockConsumeService.insert(detail);
	}
	
	@Transactional(value = DsConstants.DATABASE_CREDITS)
	public void consumeDevSingleLotteryStock(Long appSingleLotteryId,
			Long appId,String bizId,String bizSource) throws BusinessException {
		
		//锁
		AppSingleLotteryDto appSingle = singleLotteryService.findForupdate(appSingleLotteryId);
		if(null == appSingle){
			throw new BusinessException("不存在的单品抽奖");
		}
		//大奖
		if(appSingle.getMainAppItemRemaining() <= 0){
			throw new BusinessException("库存不足");
		}
		int ret = singleLotteryService.reduceMainAppItemRemaining(appSingle.getId());
		if(ret < 1){
			throw new BusinessException("抽奖失败，更新小奖剩余数量异常");
		}
		Date now = new Date(System.currentTimeMillis()/1000*1000);

		SingleLotteryStockConsumeDto consume = new SingleLotteryStockConsumeDto(true);
		consume.setRelationId(appSingle.getId());//对于单品抽奖取单品id
		consume.setRelationType(SingleLotteryStockConsumeDto.TYPE_DEV_ITEM);
		consume.setAppId(appId);
		consume.setAction(SingleLotteryStockConsumeDto.ACTION_PAY);
		consume.setBizId(bizId);
		consume.setOptionType(SingleLotteryStockConsumeDto.OPTION_MAIN);
		consume.setBizSource(bizSource);
		consume.setQuantity(1L);
		consume.setGmtCreate(now);
		consume.setGmtModified(now);

		singleLotteryStockConsumeService.insert(consume);
	}

	@Transactional(value = DsConstants.DATABASE_CREDITS)
	public void pabackDevSingleLoteryStock(String bizId,String bizSource) throws BusinessException {
		
		SingleLotteryStockConsumeDto consume = singleLotteryStockConsumeService.findByBizIdAndSource(bizId, bizSource);
		
		if(null == consume){
			log.error("无消费记录");
			return;
		}
		
		//锁
		AppSingleLotteryDto appSingle = singleLotteryService.findForupdate(consume.getRelationId());
		if(null == appSingle){
			log.error("无记录");
			return;
		}
		int ret = singleLotteryService.addMainAppItemRemaining(appSingle.getId());
		if(ret < 1){
			throw new BusinessException("抽奖失败，更新小奖剩余数量异常");
		}
		Date now = new Date(System.currentTimeMillis()/1000*1000);

		SingleLotteryStockConsumeDto detail = new SingleLotteryStockConsumeDto(true);
		detail.setRelationId(consume.getRelationId());//对于单品抽奖取单品id
		detail.setRelationType(consume.getRelationType());
		detail.setAppId(consume.getAppId());
		detail.setAction(SingleLotteryStockConsumeDto.ACTION_BACK);
		detail.setBizId(consume.getBizId());
		detail.setOptionType(consume.getOptionType());
		detail.setBizSource(consume.getBizSource());
		detail.setQuantity(1L);
		detail.setGmtCreate(now);
		detail.setGmtModified(now);

		singleLotteryStockConsumeService.insert(detail);
	}

}
