package cn.com.duiba.activity.center.biz.dao.elasticgifts;

import cn.com.duiba.activity.center.biz.entity.elasticgifts.ElasticGiftsAppEntity;

import java.util.List;

/**
 * 弹层礼包 app 配置
 */
public interface ElasticGiftsAppDao {

    /**
     * 获取弹层礼包的定制 apps
     * @param elasticGiftsId
     * @return
     */
    List<Long> getAppIdsByElasticGiftsId(Long elasticGiftsId);

    /**
     * 根据业务编号和活动 id 查询
     * @param bizCode
     * @param elasticGiftsId
     * @return
     */
    List<ElasticGiftsAppEntity> findAllByBizCodeAndElId(Integer bizCode, Long elasticGiftsId);

    /**
     * 根据业务编号和 appIds 去删除
     * @param bizCode
     * @param appIds
     * @return
     */
    int deleteByBizCodeAndAppIds(Integer bizCode, List<Long> appIds);

    /**
     * 根据 ids 删除
     * @param ids
     * @return
     */
    int deleteByIds(List<Long> ids);

    /**
     * 插入操作
     * @param entity
     * @return
     */
    int insert(ElasticGiftsAppEntity entity);

    /**
     * 根据 bizCode 和 appId 查询
     * @param bizCode
     * @param appId
     * @return
     */
    ElasticGiftsAppEntity findByBizCodeAndAppId(Integer bizCode, Long appId);

    /**
     * 更新活动 id.根据 appid
     * @param elasticGiftsId
     * @param appId
     * @return
     */
    int updateElasticGiftsIdByAppId(Long elasticGiftsId, Long appId, Integer bizCode);
}
