package cn.com.duiba.activity.center.biz.dao.elasticgifts.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.elasticgifts.ElasticGiftsTermDao;
import cn.com.duiba.activity.center.biz.entity.elasticgifts.ElasticGiftsTermEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository("elasticGiftsTermDao")
public class ElasticGiftsTermDaoImpl extends ActivityBaseDao implements ElasticGiftsTermDao {

    @Override
    public List<ElasticGiftsTermEntity> findAllByIds(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("ids", ids);
        return this.selectList("findAllByIds", paramMap);
    }

    @Override
    public List<ElasticGiftsTermEntity> findAllByElId(Long elasticGiftsId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("elasticGiftsId", elasticGiftsId);
        return this.selectList("findAllByElId", paramMap);
    }

    @Override
    public int deleteByElId(Long elasticGiftsId) {
        return this.update("deleteByElId", elasticGiftsId);
    }

    @Override
    public int insert(ElasticGiftsTermEntity entity) {
        return this.insert("insert", entity);
    }

    @Override
    public int delete(Long id) {
        return this.update("delete", id);
    }

    @Override
    public int update(ElasticGiftsTermEntity entity) {
        return this.update("update", entity);
    }

    @Override
    public ElasticGiftsTermEntity find(Long id) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        return this.selectOne("find", paramMap);
    }

    @Override
    public int updatePayloadById(Long id, Integer payload) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("payload", payload);
        return this.update("updatePayloadById", paramMap);
    }

    @Override
    public Integer getMaxPayload() {
        Integer maxPayload = this.selectOne("getMaxPayload");
        return maxPayload == null ? 0 : maxPayload;
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }
}
