package cn.com.duiba.activity.center.biz.dao.game.impl;

import java.util.*;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.game.GameOrdersSimpleDao;
import cn.com.duiba.activity.center.biz.entity.DeveloperActivityStatisticsEntity;
import cn.com.duiba.activity.center.biz.entity.game.GameOrdersEntity;
import cn.com.duiba.activity.center.biz.entity.game.GameOrdersSimpleEntity;
import org.springframework.stereotype.Repository;


@Repository
public class GameOrdersSimpleDaoImpl extends ActivityBaseDao implements GameOrdersSimpleDao {

	@Override
	public GameOrdersEntity find(Long gameOrderId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", gameOrderId);
		return selectOne("find", paramMap);
	}

	@Override
	public List<GameOrdersEntity> findByIds(List<Long> ids) {
		if (ids == null || ids.size() <= 0) {
			return null;
		}
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("ids", ids);
		return selectList("findByIds", paramMap);
	}

	@Override
	public void insert(GameOrdersEntity GameOrdersDto) {
		insert("insert", GameOrdersDto);
	}

	@Override
	public Integer findConsumerFreeNumber(Long consumerId, Long operatingActivityId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("consumerId", consumerId);
		paramMap.put("operatingActivityId", operatingActivityId);
		return selectOne("findConsumerFreeNumber", paramMap);
	}

	@Override
	public Integer findConsumerFreeNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("consumerId", consumerId);
		paramMap.put("operatingActivityId", operatingActivityId);
		paramMap.put("start", start);
		paramMap.put("end", end);
		return selectOne("findConsumerFreeNumberByDate", paramMap);
	}

	@Override
	public Integer findConsumerLimitNumber(Long consumerId, Long operatingActivityId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("consumerId", consumerId);
		paramMap.put("operatingActivityId", operatingActivityId);
		return selectOne("findConsumerLimitNumber", paramMap);
	}

	@Override
	public Integer findConsumerLimitNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("consumerId", consumerId);
		paramMap.put("operatingActivityId", operatingActivityId);
		paramMap.put("start", start);
		paramMap.put("end", end);
		return selectOne("findConsumerLimitNumberByDate", paramMap);
	}

	@Override
	public GameOrdersEntity findByAppAndDeveloperBizId(Long appId, String bizId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("appId", appId);
		paramMap.put("bizId", bizId);
		return selectOne("findByAppAndDeveloperBizId", paramMap);
	}

	@Override
	public Integer countConsumerByPrizeId(Long consumerId, Long operatingActivityId, Long prizeId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("consumerId", consumerId);
		paramMap.put("operatingActivityId", operatingActivityId);
		paramMap.put("prizeId", prizeId);
		return selectOne("countConsumerByPrizeId", paramMap);
	}

	@Override
	public List<Long> findOverdueOrder() {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("prizeOverdueDate", new Date());
		paramMap.put("exchangeStatus", GameOrdersEntity.ExchangeStatusWait);
		return selectList("findOverdueOrder", paramMap);
	}

	@Override
	public Integer countConsumerByGameConfigDuibaId(Long consumerId, Long gameConfigDuibaId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("consumerId", consumerId);
		paramMap.put("gameConfigDuibaId", gameConfigDuibaId);
		return selectOne("countConsumerByGameConfigDuibaId", paramMap);
	}

	@Override
	public Long countRow(Map<String, Object> paramMap) {
		return selectOne("countRow", paramMap);
	}

	@Override
	public List<GameOrdersSimpleEntity> findByLimit(Map<String, Object> paramMap) {
		return selectList("findByLimit", paramMap);
	}

	@Override
	public List<DeveloperActivityStatisticsEntity> countFailByOperatingActivityIds(List<Long> ids) {
		if (ids == null || ids.size() == 0) {
			return new ArrayList<DeveloperActivityStatisticsEntity>();
		}
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("ids", ids);
		return selectList("countFailByOperatingActivityIds", paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_GAME;
	}
}
