package cn.com.duiba.activity.center.biz.dao.ngame_app.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.ngame_app.NgameOrdersAppDao;
import cn.com.duiba.activity.center.biz.entity.DeveloperActivityStatisticsEntity;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameOrdersEntity;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

import static cn.com.duiba.activity.center.biz.support.TableHelper.getTbSuffixParamsMap;

@Repository
public class NgameOrdersAppDaoImpl extends ActivityBaseDao implements NgameOrdersAppDao {

	@Override
	public List<NgameOrdersEntity> findByLimit(Map<String, Object> queryMap) {
		Long appId= (Long)queryMap.get("appId");
		Map<String, Object> paramMap = getTbSuffixParamsMap(appId);
		paramMap.putAll(queryMap);
		return selectList("findByLimit", paramMap);
	}

	@Override
	public Long totalCount(Map<String, Object> queryMap) {
		Long appId= (Long)queryMap.get("appId");
		Map<String, Object> paramMap = getTbSuffixParamsMap(appId);
		paramMap.putAll(queryMap);
		return selectOne("totalCount", paramMap);
	}
	
	@Override
	public List<DeveloperActivityStatisticsEntity> countFailByOperatingActivityIds(List<Long> ids, Long appId) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(appId);
		paramMap.put("ids", ids);
		paramMap.put("appId", appId);
		return selectList("countFailByOperatingActivityIds", paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.NGAME_APP;
	}
}
