package cn.com.duiba.activity.center.biz.dao.seconds_kill.impl;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.seconds_kill.DuibaSecondsKillActivityDao;
import cn.com.duiba.activity.center.biz.entity.AddActivityEntity;
import cn.com.duiba.activity.center.biz.entity.seconds_kill.DuibaSecondsKillActivityEntity;

@Repository
public class DuibaSecondsKillActivityDaoImpl extends ActivityBaseDao implements DuibaSecondsKillActivityDao{

	@Override
	public DuibaSecondsKillActivityEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find",paramMap);
	}
	
	@Override
    public String findTagById(Long id) {
        return selectOne("findTagById",id);
    }

	@Override
	public List<AddActivityEntity> findAllDuibaSecondKillByAppId(Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("appId", appId);
		return selectList("findAllDuibaSecondKillByAppId",paramMap);
	}

	@Override
	public List<DuibaSecondsKillActivityEntity> findAllByIds(List<Long> ids) {
		if(ids.isEmpty()){
			return Collections.emptyList();
		}
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("ids", ids);
		return selectList("findAllByIds",paramMap);
	}

	@Override
	public List<DuibaSecondsKillActivityEntity> findAutoOff() {
		Calendar cal1 = Calendar.getInstance();
		cal1.setTime(new Date());
		cal1.add(Calendar.DATE, -1);
		Date startTime = cal1.getTime();

		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("startTime", startTime);
		paramMap.put("endTime", new Date());
		return selectList("findAutoOff", paramMap);
	}

	@Override
	public void changeStatus(Long id, Integer status) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("status", status);
		update("changeStatus", paramMap);
	}




	@Override
	public List<DuibaSecondsKillActivityEntity> findByPage(Map<String, Object> params) {
		return selectList("findByPage", params);
	}

	@Override
	public int count() {
		return selectOne("count");
	}

	@Override
	public int count(Map<String, Object> params) {
		return selectOne("count",params);
	}

	@Override
	public void insert(DuibaSecondsKillActivityEntity DuibaSecondsKillActivityEntity) {
		insert("insert", DuibaSecondsKillActivityEntity);
	}

	@Override
	public int updateAutoOffDateNull(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return update("updateAutoOffDateNull", paramMap);
	}
	
	@Override
    public int updateTagById(Long id, String tag) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("tag", tag);
        return update("updateTagById", paramMap);
    }

	@Override
	public void deleteById(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		update("deleteById", paramMap);
	}

	@Override
	public void updateSwitches(Long id, Long switches) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("switches", switches);
		update("updateSwitches", paramMap);
	}

	@Override
	public void update(DuibaSecondsKillActivityEntity DuibaSecondsKillActivityEntity) {
		update("update", DuibaSecondsKillActivityEntity);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS;
	}
}
