/**
 * Project Name:activity-center-biz File Name:PushAppsConfig.java Package Name:cn.com.duiba.activity.center.biz.domain
 * Date:2016年10月9日下午3:28:25 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.domain;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import cn.com.duiba.activity.center.biz.entity.config.CenterConfigEntity;

import com.google.common.base.Splitter;

/**
 * 推送app配置对象 Date: 2016年10月9日 下午3:28:25 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public class PushAppsConfig {

    /** 版本号 */
    private Long       version;

    /** 推送appId列表 */
    private List<Long> appIdList = new ArrayList<Long>();

    public PushAppsConfig(CenterConfigEntity config) {
        if(config == null){
            return;
        }
        this.version = config.getVersion();
        if (StringUtils.isNotBlank(config.getValue())) {
            List<String> appIdStrList = Splitter.on(',').splitToList(config.getValue());
            for (String str : appIdStrList) {
                appIdList.add(Long.parseLong(str));
            }
        }
    }

    public Long getVersion() {
        return version;
    }

    public List<Long> getAppIdList() {
        return appIdList;
    }
}
