/**
 * Project Name:activity-center-biz
 * File Name:ActivityOrderPluginImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.plugin
 * Date:2016年7月27日下午7:11:10
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.plugin.event.order.impl;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsRegister;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent.ActivityOrdersEventListener;
import cn.com.duiba.activity.center.biz.tools.RedisClientTool;
import cn.com.duiba.activity.center.biz.tools.service.AppTradingLimitService;
import cn.com.duiba.activity.center.biz.tools.service.TodayActivityStatisticsService;
import cn.com.duiba.activity.center.biz.tools.service.TodayCountService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;

/**
 * ClassName:ActivityOrderPluginImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月27日 下午7:11:10 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
public class ActivityOrderPluginImpl implements InitializingBean{
    
    @Autowired
    private AppTradingLimitService appTradingLimit;
    @Autowired
    private TodayCountService todayCountService;
    @Autowired
    private TodayActivityStatisticsService todayActivityStatisticsService;
    @Autowired
    private RedisClientTool redisClientTool;

    @Override
    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registActivityOrdersEvent(new ActivityOrdersEventListener() {
            @Override
            public void onOrderSuccess(ActivityOrderDto order) {
                appTradingLimit.addTrading(order.getAppId());
                todayCountService.addExpectByCredits(order.getAppId(), order.getConsumeCredits());
                todayActivityStatisticsService.addTodayWinCount(order.getDuibaActivityId(),order.getActivityType(),order.getAppId());
            }
            @Override
            public void onOrderFail(ActivityOrderDto order) {
                todayActivityStatisticsService.rollbackTodayConsumeCredits(order.getDuibaActivityId(),order.getActivityType(),order.getAppId(),order.getConsumeCredits());
            }
            @Override
            public void onOrderCreate(ActivityOrderDto order) {
                redisClientTool.setValue(order.getConsumerId(),order.getDuibaActivityId(),order.getActivityType(), order.getOrderNum());
                todayActivityStatisticsService.addTodayConsumeCredits(order.getDuibaActivityId(),order.getActivityType(),order.getAppId(),order.getConsumeCredits());
            }
        });
    }

}

