package cn.com.duiba.activity.center.biz.remoteservice.impl.activity;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityOptionsDto;
import cn.com.duiba.activity.center.api.dto.activity.QuestionRecordDto;
import cn.com.duiba.activity.center.api.remoteservice.activity.RemoteOperatingActivityOptionsService;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityOptionsService;
import cn.com.duiba.activity.center.biz.service.game.DevelopQuestionRecordService;

/**
 * Created by yansen on 16/6/12.
 */
@Service
public class RemoteOperatingActivityOptionsServiceImpl implements RemoteOperatingActivityOptionsService {

    @Resource
    private OperatingActivityOptionsService operatingActivityOptionsService;
    @Resource
    private DevelopQuestionRecordService developQuestionRecordService;

    @Override
    public OperatingActivityOptionsDto findOptionById(Long id) {
        return operatingActivityOptionsService.findOptionById(id);
    }

    @Override
    public List<OperatingActivityOptionsDto> findByOperatingActivityId(Long operatingActivityId) {
        return operatingActivityOptionsService.findByOperatingActivityId(operatingActivityId);
    }

    @Override
    public Integer countByOperatingActivityId(Long operatingActivityId) {
        return operatingActivityOptionsService.countByOperatingActivityId(operatingActivityId);
    }

    @Override
    public int decrementOptionRemaining(Long optionId) {
        return operatingActivityOptionsService.decrementOptionRemaining(optionId);
    }

    @Override
    public int incrementOptionRemaining(Long optionId) {
        return operatingActivityOptionsService.incrementOptionRemaining(optionId);
    }

    @Override
    public int updateOptionDeleteStatus(List<Long> oaoList) {
        return operatingActivityOptionsService.updateOptionDeleteStatus(oaoList);
    }

    @Override
    public int updatePrize(OperatingActivityOptionsDto operatingActivityOptionsDO) {
        return operatingActivityOptionsService.updatePrize(operatingActivityOptionsDO);
    }

    @Override
    public OperatingActivityOptionsDto insertOption(OperatingActivityOptionsDto operatingActivityOptionsDO) {
        operatingActivityOptionsService.insertOption(operatingActivityOptionsDO);
        return operatingActivityOptionsDO;
    }

    @Override
    public int updateOption(OperatingActivityOptionsDto operatingActivityOptionsDO) {
        return operatingActivityOptionsService.updateOption(operatingActivityOptionsDO);
    }

    @Override
    public int addRemainingById(Long id, Integer addRemaining) {
        return operatingActivityOptionsService.addRemainingById(id, addRemaining);
    }

    @Override
    public int subRemainingById(Long id, Integer subRemaining) {
        return operatingActivityOptionsService.subRemainingById(id, subRemaining);
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        return operatingActivityOptionsService.updateRemainingById(id, remaining);
    }

    @Override
    public Integer findRemaingForupdate(Long id) {
        return operatingActivityOptionsService.findRemaingForupdate(id);
    }

	@Override
	public List<QuestionRecordDto> findByQuestionRecordId(Long activityId) {
		return developQuestionRecordService.findByQuestionRecordId(activityId);
	}

	@Override
	public void saveOrUpdateQuestionRecord(Long activityId, String[] questionRecord,int optionNum) {
		developQuestionRecordService.saveOrUpdateQuestionRecord(activityId, questionRecord,optionNum);
	}

}
