package cn.com.duiba.activity.center.biz.remoteservice.impl.elasticgifts;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsEditDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsListDto;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsBizCodeEnum;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsStatusEnum;
import cn.com.duiba.activity.center.api.remoteservice.elasticgifts.RemoteElasticGiftsBackendService;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.activity.center.biz.service.elasticgifts.ElasticGiftsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("remoteElasticGiftsBackendService")
public class RemoteElasticGiftsBackendServiceImpl implements RemoteElasticGiftsBackendService {

    private static Logger LOGGER = LoggerFactory.getLogger(RemoteElasticGiftsBackendServiceImpl.class);

    @Autowired
    private ElasticGiftsService elasticGiftsService;

    @Override
    public DubboResult<Page<ElasticGiftsListDto>> findElasticGiftsPage(Integer currentPage, Integer pageSize, ElasticGiftsBizCodeEnum bizCode, Long elasticGiftsId, String title4admin) {
        try {
            Page<ElasticGiftsListDto> result = elasticGiftsService.findElasticGiftsPage(currentPage, pageSize, bizCode, elasticGiftsId, title4admin);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("findElasticGiftsPage error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> updateStatus(Long elasticGiftsId, ElasticGiftsStatusEnum targetStatus) {
        try {
            Boolean result = elasticGiftsService.updateStatus(elasticGiftsId, targetStatus);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("updateStatus error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<Long>> getAppIdsByElasticGiftsId(Long elasticGiftsId) {
        try {
            List<Long> result = elasticGiftsService.getAppIdsByElasticGiftsId(elasticGiftsId);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("getAppIdsByElasticGiftsId error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> delete(Long elasticGiftsId) {
        try {
            Boolean result = elasticGiftsService.delete(elasticGiftsId);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("delete error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> save(Long elasticGiftsId, String title4admin, ElasticGiftsBizCodeEnum bizCode, List<Long> termIds) {
        try {
            Boolean result = elasticGiftsService.save(elasticGiftsId, title4admin, bizCode, termIds);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("save error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<ElasticGiftsEditDto> getElasticGiftsById(Long elasticGiftsId) {
        try {
            ElasticGiftsEditDto result = elasticGiftsService.getElasticGiftsById(elasticGiftsId);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("getElasticGiftsById error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ElasticGiftsDto>> getElasticGiftsByText(ElasticGiftsBizCodeEnum bizCode, String text) {
        try {
            List<ElasticGiftsDto> result = elasticGiftsService.getElasticGiftsByText(bizCode, text);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("getElasticGiftsByText error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
