package cn.com.duiba.activity.center.biz.remoteservice.impl.game;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerBrickDto;
import cn.com.duiba.activity.center.api.remoteservice.game.RemoteDuibaQuestionAnswerBrickService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerBrickService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/6/2.
 */
@Service
public class RemoteDuibaQuestionAnswerBrickServiceImpl implements RemoteDuibaQuestionAnswerBrickService {
    @Resource
    private DuibaQuestionAnswerBrickService duibaQuestionAnswerBrickService;

    @Override
    public DuibaQuestionAnswerBrickDto find(Long id) {
        return duibaQuestionAnswerBrickService.find(id);
    }

    @Override
    public DuibaQuestionAnswerBrickDto insert(DuibaQuestionAnswerBrickDto duibaQuestionAnswerBrick) {
        duibaQuestionAnswerBrickService.insert(duibaQuestionAnswerBrick);
        return duibaQuestionAnswerBrick;
    }

    @Override
    public void update4Admin(Long id, String title, String content, String md5) {
        duibaQuestionAnswerBrickService.update4Admin(id, title, content, md5);
    }

    @Override
    public DuibaQuestionAnswerBrickDto findByTitle(String title) {
        return duibaQuestionAnswerBrickService.findByTitle(title);
    }

    @Override
    public void open(Long id) {
        duibaQuestionAnswerBrickService.open(id);
    }

    @Override
    public void disable(Long id) {
        duibaQuestionAnswerBrickService.disable(id);
    }

    @Override
    public List<DuibaQuestionAnswerBrickDto> findPage(Map<String, Object> queryMap) {
        return duibaQuestionAnswerBrickService.findPage(queryMap);
    }

    @Override
    public Long findPageCount() {
        return duibaQuestionAnswerBrickService.findPageCount();
    }

    @Override
    public List<DuibaQuestionAnswerBrickDto> findAll() {
        return duibaQuestionAnswerBrickService.findAll();
    }

    @Override
    public String getBrickContentById(Long id) {
        return duibaQuestionAnswerBrickService.getBrickContentById(id);
    }

    @Override
    public DuibaQuestionAnswerBrickDto findNoContent(Long id) {
        return duibaQuestionAnswerBrickService.findNoContent(id);
    }
}
