package cn.com.duiba.activity.center.biz.remoteservice.impl.guess;

import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessBrickDto;
import cn.com.duiba.activity.center.api.remoteservice.guess.RemoteDuibaGuessBrickService;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessBrickService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/7/18.
 */
@Service
public class RemoteDuibaGuessBrickServiceImpl implements RemoteDuibaGuessBrickService {

    @Autowired
    private DuibaGuessBrickService duibaGuessBrickService;

    @Override
    public DuibaGuessBrickDto find(Long id) {
        return duibaGuessBrickService.find(id);
    }

    @Override
    public String getBrickContentById(Long id) {
        return duibaGuessBrickService.getBrickContentById(id);
    }

    @Override
    public DuibaGuessBrickDto findNoContent(Long id) {
        return duibaGuessBrickService.findNoContent(id);
    }

    @Override
    public String getBrickPrizeContentById(Long id) {
        return duibaGuessBrickService.getBrickContentById(id);
    }

    @Override
    public DuibaGuessBrickDto insert(DuibaGuessBrickDto duibaGuessBrick) {
        duibaGuessBrickService.insert(duibaGuessBrick);
        return duibaGuessBrick;
    }

    @Override
    public void update4Admin(Long id, String title, String content, String prizeContent, String md5) {
        duibaGuessBrickService.update4Admin(id, title, content, prizeContent, md5);
    }

    @Override
    public DuibaGuessBrickDto findByTitle(String title) {
        return duibaGuessBrickService.findByTitle(title);
    }

    @Override
    public void open(Long id) {
        duibaGuessBrickService.open(id);
    }

    @Override
    public void disable(Long id) {
        duibaGuessBrickService.disable(id);
    }

    @Override
    public List<DuibaGuessBrickDto> findPage(Integer offset, Integer max) {
        return duibaGuessBrickService.findPage(offset, max);
    }

    @Override
    public Long findPageCount() {
        return duibaGuessBrickService.findPageCount();
    }

    @Override
    public List<DuibaGuessBrickDto> findAll() {
        return duibaGuessBrickService.findAll();
    }
}
