package cn.com.duiba.activity.center.biz.remoteservice.impl.guess;

import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessOptionsDto;
import cn.com.duiba.activity.center.api.remoteservice.guess.RemoteDuibaGuessOptionsService;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessOptionsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/7/26.
 */
@Service
public class RemoteDuibaGuessOptionsServiceImpl implements RemoteDuibaGuessOptionsService {

    @Autowired
    private DuibaGuessOptionsService duibaGuessOptionsService;

    @Override
    public List<DuibaGuessOptionsDto> findByGuessId(Long guessId) {
        return duibaGuessOptionsService.findByGuessId(guessId);
    }

    @Override
    public DuibaGuessOptionsDto findById(Long id) {
        return duibaGuessOptionsService.findById(id);
    }

    @Override
    public List<DuibaGuessOptionsDto> findByAutoOpen(Long guessId, boolean autoOpen) {
        return duibaGuessOptionsService.findByAutoOpen(guessId,autoOpen);
    }

    @Override
    public List<DuibaGuessOptionsDto> findByAutoOpenAsc(Long guessId, boolean autoOpen) {
        return duibaGuessOptionsService.findByAutoOpenAsc(guessId,autoOpen);
    }

    @Override
    public int delete(List<Long> ids) {
        return duibaGuessOptionsService.delete(ids);
    }

    @Override
    public DuibaGuessOptionsDto insert(DuibaGuessOptionsDto duibaGuessOptionsDto) {
        duibaGuessOptionsService.insert(duibaGuessOptionsDto);
        return duibaGuessOptionsDto;
    }

    @Override
    public int updateInfoForm(DuibaGuessOptionsDto duibaGuessOptionsDto) {
        return duibaGuessOptionsService.updateInfoForm(duibaGuessOptionsDto);
    }

    /**
     * 更新库存
     *
     * @param id
     * @param remaining
     */
    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        return duibaGuessOptionsService.updateRemainingById(id,remaining);
    }
}
