/**
 * Project Name:activity-center-biz
 * File Name:RemoteTodayRobConfigServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.remoteservice.impl.rob
 * Date:2016年7月25日下午3:22:38
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.remoteservice.impl.littleGame;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.api.remoteservice.littlegame.RemoteLittleGameService;
import cn.com.duiba.activity.center.biz.dao.other.DuibaRemainingMoneyDAO;
import cn.com.duiba.activity.center.biz.dao.other.NotifyQueueDAOImpl;
import cn.com.duiba.activity.center.biz.kafka.TopicConstant;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCreditsCallback;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent.ActivityOrderPluginContext;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.activity.center.biz.service.prize.ActivityPrizeOptionService;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobConfigService;
import cn.com.duiba.activity.center.biz.tools.service.ActualPriceCalService;
import cn.com.duiba.activity.center.biz.tools.service.FrequentExchangeLimitService;
import cn.com.duiba.activity.center.biz.tools.service.ItemKeyStockServcie;
import cn.com.duiba.activity.center.biz.tools.service.TimeLimitService;
import cn.com.duiba.activity.center.biz.utils.MemLock;
import cn.com.duiba.dcommons.flowwork.ActivityLotteryFlowworkService;
import cn.com.duiba.notifycenter.client.NotifyCenterServiceClient;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemoteAddrLimitService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * describe : 中奖service 
 * @author  : cdm
 * @date    : 2016年9月27日 下午2:13:05
 */
@Service
public class RemoteLittleGameServiceImpl implements RemoteLittleGameService{
	
	 private static Logger log = LoggerFactory.getLogger(RemoteLittleGameServiceImpl.class);
	
	@Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private TodayRobConfigService todayRobConfigService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private ConsumerCreditsCallback consumerCreditsCallback;
    @Autowired
    private ActivityPrizeOptionService activityPrizeOptionService;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private TimeLimitService timeLimitService;
    @Autowired
    private ItemKeyStockServcie itemKeyStockServcie;
    @Autowired
    private RemoteAddrLimitService remoteAddrLimitService;
    @Autowired
    private ActualPriceCalService actualPriceCalService;
    @Autowired
    private DuibaRemainingMoneyDAO duibaRemainingMoneyDAO;
    @Autowired
    private FrequentExchangeLimitService frequentExchangeLimit;
    @Autowired @Qualifier("notifyQueueDAO")
    private NotifyQueueDAOImpl notifyQueueDAO;
    @Autowired
    private NotifyCenterServiceClient notifyCenterServiceClient;
    @Autowired
    private ActivityLotteryFlowworkService activityLotteryFlowworkService;
    @Autowired
    private ActPreStockSerivce actPreStockSerivce;

	@Override
	public DubboResult<String> haveGift(Long littleGameId, String orderNum, ActivityPrizeOptionDto winOption,String ip) {
		 ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(orderNum).getResult();
		 try {
			doWinPrize(order, winOption, ip);
			 return DubboResult.successResult(orderNum);
		} catch (Exception e) {
			log.error("领取礼包异常出错",e);
    		log.error("领取礼包异常出错====礼包ID==="+winOption.getId()+"================订单号："+orderNum);
			 return DubboResult.failResult(((StatusException)e).getMessage());
		}
	}
    
	//领奖
	 public void doWinPrize(ActivityOrderDto order,ActivityPrizeOptionDto winOption,String ip) throws Exception{
	        Long couponId = null;
	        ActivityOrderPluginContext context = new ActivityOrderPluginContext();
	        MemLock lock = new MemLock();
	        lock.setLocked(false);
	        try{
	            if(winOption.getId() != null){
	                lock = frequentExchangeLimit.lockPrize(order.getDuibaActivityId(),order.getActivityType(),winOption.getId());
	                if(lock.isLocked()){
	                    DuibaEventsDispatcher.get().triggerBeforeActivityOrderComplete(order, winOption, context);
	                    Object obj = context.getAttribute("couponId");
	                    if(null != obj){
	                        couponId = (Long)obj;
	                    }
	                }else{
	                    //降级
	                    throw new Exception("降级处理");
	                }
	            }
	            remoteActivityOrderService.consumeCreditsSuccess(order.getOrderNum(),winOption.getId(),winOption.getPrizeName(),
                        winOption.getPrizeType(),winOption.getFacePrice(),winOption.getAppItemId(),
                        winOption.getItemId(),winOption.getgId(),winOption.getgType(),couponId);
	        }catch(Exception e){
	            if (lock.isLocked()) {
	                DuibaEventsDispatcher.get().triggerOnActivityOrderCompleteException(order, winOption, e, context);
	            }
	            log.error("className: " + this.getClass().getName() + " method: doWinPrize", e);
	            throw e;
	        }finally{
	            if(lock.isLocked()){
	                frequentExchangeLimit.unlockPrize(order.getDuibaActivityId(),order.getActivityType(), winOption.getId());
	            }
	        }
	        if(!winOption.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)){
	            //创建兑换记录
	            activityLotteryFlowworkService.insertCosumerExchanageRecord(order.getConsumerId(),order.getOrderNum(),order.getActivityType(),winOption.getPrizeType());
	        }
	        //优惠券自动领奖
	        if(winOption.getPrizeType().equals(ItemDO.TypeCoupon)){
	            try{
	                activityLotteryFlowworkService.autoTakePrize(order.getOrderNum(),order.getConsumerId(), order.getAppId(),ip, null);
	            }catch(Exception e){
	                log.error("礼包扣库存自动发奖异常================优惠券领奖异常",e);
	            }
	        }
	    }
	
	
}

