package cn.com.duiba.activity.center.biz.remoteservice.impl.ngame;

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.remoteservice.ngame.RemoteDuibaNgameService;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/13.
 */
@Service
public class RemoteDuibaNgameServiceImpl implements RemoteDuibaNgameService {
    @Resource
    private DuibaNgameService duibaNgameService;

    @Override
    public List<DuibaNgameDto> findByPage(Integer offset, Integer max, String title, Integer id) {
        return duibaNgameService.findByPage(offset, max, title, id);
    }

    @Override
    public Long findByPageCount(String title, Integer id) {
        return duibaNgameService.findByPageCount(title, id);
    }

    @Override
    public DuibaNgameDto findOpenPrizeForUpdate(Long id) {
        return duibaNgameService.findOpenPrizeForUpdate(id);
    }

    @Override
    public int count() {
        return duibaNgameService.count();
    }

    @Override
    public String findTagById(Long id) {
        return duibaNgameService.findTagById(id);
    }

    @Override
    public DuibaNgameDto find(Long id) {
        return duibaNgameService.find(id);
    }

    @Override
    public DuibaNgameDto add(DuibaNgameDto duibaNgameDO) {
        duibaNgameService.add(duibaNgameDO);
        return duibaNgameDO;
    }

    @Override
    public void delete(Long id) {
        duibaNgameService.delete(id);
    }
    
    @Override
    public int updateTagById(Long id, String tag){
        return duibaNgameService.updateTagById(id, tag);
    }

    @Override
    public void update(DuibaNgameDto duibaNgameDO) {
        duibaNgameService.update(duibaNgameDO);
    }

    @Override
    public void updateSwitch(DuibaNgameDto duibaNgameDO) {
        duibaNgameService.updateSwitch(duibaNgameDO);
    }

    @Override
    public List<DuibaNgameDto> findAllByIds(List<Long> ids) {
        return duibaNgameService.findAllByIds(ids);
    }

    @Override
    public List<AddActivityDto> findAllNgame(Long appId) {
        return duibaNgameService.findAllNgame(appId);
    }

    @Override
    public List<DuibaNgameDto> findListByIds(List<Long> ids) {
        return duibaNgameService.findListByIds(ids);
    }

    @Override
    public int updateOpenPrize(Long id) {
        return duibaNgameService.updateOpenPrize(id);
    }

    @Override
    public List<DuibaNgameDto> findAutoOff() {
        return duibaNgameService.findAutoOff();
    }

    @Override
    public int updateStatus(Long id, Integer status) {
        return duibaNgameService.updateStatus(id, status);
    }

    @Override
    public ActivityExtraInfoDto findExtraInfoById(Long id) {
        return duibaNgameService.findExtraInfoById(id);
    }

    @Override
	public int updateActivityCategoryId(long id,Long activityCategoryId){
    	return duibaNgameService.updateActivityCategoryId(id, activityCategoryId);
    }
}
