package cn.com.duiba.activity.center.biz.service.activity.Impl;

import cn.com.duiba.activity.center.api.dto.ActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.biz.dao.activity.OperatingActivityDao;
import cn.com.duiba.activity.center.biz.entity.activity.OperatingActivityEntity;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;

import javax.annotation.Resource;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * Created by yansen on 16/6/14.
 */
@Service
public class OperatingActivityServiceImpl implements OperatingActivityService{

    @Autowired
    private OperatingActivityDao operatingActivityDao;

    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return CacheConstants.KEY_OPERATING_ACTIVITY_BY_ID + id;
    }


    @Override
    public List<OperatingActivityDto> findGameByAppIdAndActivityId(Long appId, List<Long> duibaActivityIds, Integer type) {
        return BeanUtils.copyList(operatingActivityDao.findGameByAppIdAndActivityId(appId, duibaActivityIds, type),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllAppTasksContent(Long appId) {
        return BeanUtils.copyList(operatingActivityDao.findAllAppTasksContent(appId),OperatingActivityDto.class);
    }

    @Override
    public List<Long> findOpenLotteryIds() {
        return operatingActivityDao.findOpenLotteryIds();
    }

    @Override
    public List<OperatingActivityDto> findAllOpenDuibaActivity(Long duibaActivityId) {
        return BeanUtils.copyList(operatingActivityDao.findAllOpenDuibaActivity(duibaActivityId),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaActivityIdAndDeleted(Long appId, Long duibaActivityId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdAndDuibaActivityIdAndDeleted(appId, duibaActivityId, deleted),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaTurntableIdAndDeleted(Long appId, Long duibaTurntableId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdAndDuibaTurntableIdAndDeleted(appId, duibaTurntableId, deleted),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndGameConfigDuibaIdAndDeleted(Long appId, Long gameConfigDuibaId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdAndGameConfigDuibaIdAndDeleted(appId, gameConfigDuibaId, deleted),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaSingleLotteryIdAndDeleted(Long appId, Long duibaSingleLotteryId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdAndDuibaSingleLotteryIdAndDeleted(appId, duibaSingleLotteryId, deleted),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaQuestionAnswerIdAndDeleted(Long appId, Long duibaQuestionAnswerId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdAndDuibaQuestionAnswerIdAndDeleted(appId, duibaQuestionAnswerId, deleted),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaSeckillIdAndDeleted(Long appId, Long duibaSeckillId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdAndDuibaSeckillIdAndDeleted(appId, duibaSeckillId, deleted),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaHdtoolIdAndDeleted(Long appId, Long duibaHdtoolId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdAndDuibaHdtoolIdAndDeleted(appId, duibaHdtoolId, deleted),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaQuizzIdAndDeleted(Long appId, Long duibaQuizzId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdAndDuibaQuizzIdAndDeleted(appId, duibaQuizzId, deleted),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndAppSingleLotteryIdAndDeleted(Long appId, Long appSingleLotteryId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdAndAppSingleLotteryIdAndDeleted(appId, appSingleLotteryId, deleted),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndAppManualLotteryAndDeleted(Long appId, Long appManualLotteryId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdAndAppManualLotteryAndDeleted(appId, appManualLotteryId, deleted),OperatingActivityDto.class);
    }

    @Override
    public Long countActivity(Map<String, Object> params) {
        return operatingActivityDao.countActivity(params);
    }

    @Override
    public List<ActivityDto> findActivityList(Map<String, Object> params) {
        return BeanUtils.copyList(operatingActivityDao.findActivityList(params),ActivityDto.class);
    }

    @Override
    public List<ActivityDto> findRecommendActivityList(Long appId) {
        return BeanUtils.copyList(operatingActivityDao.findRecommendActivityList(appId),ActivityDto.class);
    }

    @Override
    public List<ActivityDto> findActivityListByParent(Map<String, Object> params) {
        return BeanUtils.copyList(operatingActivityDao.findActivityListByParent(params),ActivityDto.class);
    }

    @Override
    public Integer deleteTurntable(Long turntableId, Long appId, Boolean delete, Integer status) {
        Integer result= operatingActivityDao.deleteTurntable(turntableId, appId, delete, status);
        cacheClient.remove(getCacheKeyById(turntableId));
        return result;
    }

    @Override
    public List<Long> findAppIdsByDuibaActivityId(Long duibaActivityId) {
        return operatingActivityDao.findAppIdsByDuibaActivityId(duibaActivityId);
    }

    @Override
    public List<Long> findAppIdsBySingleLotteryId(Long singleLotteryId) {
        return operatingActivityDao.findAppIdsBySingleLotteryId(singleLotteryId);
    }

    @Override
    public List<Long> findAppIdsByActivityIdAndType(Long activityId, Integer type) {
        return operatingActivityDao.findAppIdsByActivityIdAndType(activityId, type);
    }

    @Override
    public List<Long> findAppIdsByDuibaSingleLotteryId(Long duibaSingleLotteryId) {
        return operatingActivityDao.findAppIdsByDuibaSingleLotteryId(duibaSingleLotteryId);
    }

    @Override
    public Integer countAppByActivityIdAndType(Long activityId, Integer type) {
        return operatingActivityDao.countAppByActivityIdAndType(activityId, type);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaActivityIds(List<Long> daIdList) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaActivityIds(daIdList),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByActivityIdsAndType(List<Long> activityIds, Integer type) {
        return BeanUtils.copyList(operatingActivityDao.findAllByActivityIdsAndType(activityIds, type),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSingleLotteryIds(List<Long> dslIdList) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaSingleLotteryIds(dslIdList),OperatingActivityDto.class);
    }

    @Override
    public List<Long> findIdsByDuibaActivityId(Long duibaActivityId) {
        return operatingActivityDao.findIdsByDuibaActivityId(duibaActivityId);
    }

    @Override
    public int updateStatusByDuibaActivityId(Integer status, Long duibaActivityId) {
         List<Long> ids=operatingActivityDao.findIdsByDuibaActivityIdAndType(duibaActivityId,OperatingActivityDto.TypeDuibaActivity);
         int result= operatingActivityDao.updateStatusByDuibaActivityId(status, duibaActivityId);
         for(Long id:ids){
            cacheClient.remove(getCacheKeyById(id));
         }
         return result;
    }

    @Override
    public int updateStatusBySingleLotteryId(Integer status, Long singleLotteryId) {
        List<Long> ids=operatingActivityDao.findIdsByDuibaActivityIdAndType(singleLotteryId,OperatingActivityDto.TypeDuibaSingleLottery);
        int result= operatingActivityDao.updateStatusBySingleLotteryId(status, singleLotteryId);
        for(Long id:ids){
            cacheClient.remove(getCacheKeyById(id));
        }
        return result;
    }

    @Override
    public int updateVisitTimes(Long id) {
        int result= operatingActivityDao.updateVisitTimes(id);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    public List<Long> findIdsBySingleLotteryId(Long duibaSingleLotteryId) {
        return operatingActivityDao.findIdsBySingleLotteryId(duibaSingleLotteryId);
    }

    @Override
    public List<OperatingActivityDto> findAllByType(Integer type) {
        return BeanUtils.copyList(operatingActivityDao.findAllByType(type),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllBySingleLotteryId(Long duibaSingleLotteryId) {
        return BeanUtils.copyList(operatingActivityDao.findAllBySingleLotteryId(duibaSingleLotteryId),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllBySingleLotteryIdAndDeleted(Long duibaSingleLotteryId, Boolean deleted) {
        return BeanUtils.copyList(operatingActivityDao.findAllBySingleLotteryIdAndDeleted(duibaSingleLotteryId, deleted),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSeckillIdAndDeleted(Long duibaSeckillId, Boolean deleted) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaSeckillIdAndDeleted(duibaSeckillId, deleted),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaActivityId(Long duibaActivityId) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaActivityId(duibaActivityId),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSecondsKillId(Long duibaSecondsKillId) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaSecondsKillId(duibaSecondsKillId),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaActivityIdAndDeleted(Long duibaActivityId, Boolean deleted) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaActivityIdAndDeleted(duibaActivityId, deleted),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaQuestionAnswerIdAndDeleted(Long duibaQuestionAnswerId, Boolean deleted) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaQuestionAnswerIdAndDeleted(duibaQuestionAnswerId, deleted),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaQuizzIdAndDeleted(Long duibaQuizzId, Boolean deleted) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaQuizzIdAndDeleted(duibaQuizzId, deleted),OperatingActivityDto.class);
    }

    @Override
    public void updateStatusByActivityIdAndType(Long activityId, Integer type, Integer status) {
        List<Long> ids=operatingActivityDao.findIdsByDuibaActivityIdAndType(activityId,type);
        operatingActivityDao.updateStatusByActivityIdAndType(activityId, type, status);
        for(Long id:ids){
            cacheClient.remove(getCacheKeyById(id));
        }
    }

    @Override
    public OperatingActivityDto findByActivityIdAndTypeAndAppIdAndDeleted(Long activityId, Integer type, Long appId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByActivityIdAndTypeAndAppIdAndDeleted(activityId, type, appId, deleted),OperatingActivityDto.class);
    }

    @Override
    public List<Long> findIdsByDuibaActivityIdAndType(Long duibaActivityId, Integer type) {
        return operatingActivityDao.findIdsByDuibaActivityIdAndType(duibaActivityId, type);
    }

    @Override
    public List<OperatingActivityDto> findSingleLotteryOperaList(List<Long> activityIds, Long appId) {
        return BeanUtils.copyList(operatingActivityDao.findSingleLotteryOperaList(activityIds, appId),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByActivityIdAndParentIdAndTypeAndAppId(Long duibaActivityId, Long parentActivityId, Integer type, Long appId) {
        return BeanUtils.copy(operatingActivityDao.findByActivityIdAndParentIdAndTypeAndAppId(duibaActivityId, parentActivityId, type, appId),OperatingActivityDto.class);
    }

    @Override
    public void deleteByParentActivityIds(List<Long> parentIds) {
        List<Long> ids=operatingActivityDao.findIdsByParentIdsAndType(parentIds,OperatingActivityDto.TypeDuibaSingleLottery);
        operatingActivityDao.deleteByParentActivityIds(parentIds);
        for(Long id:ids){
            cacheClient.remove(getCacheKeyById(id));
        }
    }

    @Override
    public OperatingActivityDto findOperatingSingleLottery(Long activityId, Long appId) {
        return BeanUtils.copy(operatingActivityDao.findOperatingSingleLottery(activityId, appId),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(operatingActivityDao.findAllByIds(ids),OperatingActivityDto.class);
    }

    @Override
    public int updateManualLotteryByIds(List<Long> ids) {
        int result= operatingActivityDao.updateManualLotteryByIds(ids);
        for(Long id:ids){
            cacheClient.remove(getCacheKeyById(id));
        }
        return result;
    }

    @Override
    public List<OperatingActivityDto> findAllEnabledActivies(Long appId) {
        return BeanUtils.copyList(operatingActivityDao.findAllEnabledActivies(appId),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findActiveActivity(Long appId) {
        return BeanUtils.copyList(operatingActivityDao.findActiveActivity(appId),OperatingActivityDto.class);
    }

    @Override
    public List<Long> findAllVirtualInTurntable(Long appId) {
        return operatingActivityDao.findAllVirtualInTurntable(appId);
    }

    @Override
    public List<Long> findAllVirtualInSingleLottery(Long appId) {
        return operatingActivityDao.findAllVirtualInSingleLottery(appId);
    }

    @Override
    public List<Long> findAllVirtualInHdTool(Long appId) {
        return operatingActivityDao.findAllVirtualInHdTool(appId);
    }

    @Override
    public OperatingActivityDto find(final Long id) {
        return cacheClient.getWithCacheLoader(getCacheKeyById(id), 10, TimeUnit.MINUTES, new CacheLoader<OperatingActivityDto>() {
            @Override
            public OperatingActivityDto load() {
                return BeanUtils.copy(operatingActivityDao.find(id),OperatingActivityDto.class);
            }
        });
    }

    @Override
    public void insert(OperatingActivityDto operatingActivityDto) {
        OperatingActivityEntity entity=new OperatingActivityEntity(true);
        BeanUtils.copy(operatingActivityDto,entity);
        operatingActivityDao.insert(entity);
        operatingActivityDto.setId(entity.getId());
    }

    @Override
    public int update(OperatingActivityDto operatingActivityDto) {
        OperatingActivityEntity entity=new OperatingActivityEntity(operatingActivityDto.getId());
        BeanUtils.copy(operatingActivityDto,entity);
        int result= operatingActivityDao.update(entity);
        cacheClient.remove(getCacheKeyById(operatingActivityDto.getId()));
        return result;
    }

    @Override
    public List<Long> findAppIdsByDuibaSecondsKillId(Long duibaSecondsKillId) {
        return operatingActivityDao.findAppIdsByDuibaSecondsKillId(duibaSecondsKillId);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSecondsKillActivityId(Long duibaSecondsKillActivityId) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaSecondsKillActivityId(duibaSecondsKillActivityId),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaQuestionAnswerId(Long duibaQuestionAnswerId) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaQuestionAnswerId(duibaQuestionAnswerId),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaQuizzId(Long duibaQuizzId) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaQuizzId(duibaQuizzId),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSeckillId(Long duibaSeckillId) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaSeckillId(duibaSeckillId),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSecondsKillActivityIdAndDeleted(Long duibaSecondsKillActivityId, Boolean deleted) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaSecondsKillActivityIdAndDeleted(duibaSecondsKillActivityId, deleted),OperatingActivityDto.class);
    }

    @Override
    public void updateStatusByDuibaSecondsKillActivityId(Integer status, Long duibaSecondsKillActivityId) {
        List<Long> ids=operatingActivityDao.findIdsByDuibaActivityIdAndType(duibaSecondsKillActivityId,OperatingActivityDto.TypeSecondsKill);
        operatingActivityDao.updateStatusByDuibaSecondsKillActivityId(status, duibaSecondsKillActivityId);
        for(Long id:ids){
            cacheClient.remove(getCacheKeyById(id));
        }
    }

    @Override
    public OperatingActivityDto findGameOperatingActivity(Long appId, Long gameConfigDuibaId, Integer gameType) {
        return BeanUtils.copy(operatingActivityDao.findGameOperatingActivity(appId, gameConfigDuibaId, gameType),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findQuestionAnswerOperatingActivity(Long appId, Long activityId) {
        return BeanUtils.copy(operatingActivityDao.findQuestionAnswerOperatingActivity(appId, activityId),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findSecondsKillOperatingActivity(Long appId, Long activityId) {
        return BeanUtils.copy(operatingActivityDao.findSecondsKillOperatingActivity(appId, activityId),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaGameIdAndDeleted(Long appId, Long duibaGameId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdAndDuibaGameIdAndDeleted(appId, duibaGameId, deleted),OperatingActivityDto.class);
    }

    @Override
    public ActivityDto findByAppIdLimit(Long appId, Long activityId) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdLimit(appId, activityId),ActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByAppId(Long appId) {
        return BeanUtils.copyList(operatingActivityDao.findAllByAppId(appId),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaSecondsKillActivityIdAndDeleted(Long appId, Long duibaSecondsKillActivityId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdAndDuibaSecondsKillActivityIdAndDeleted(appId, duibaSecondsKillActivityId, deleted),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findDuibaQuestionAnswerByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type) {
        return BeanUtils.copyList(operatingActivityDao.findDuibaQuestionAnswerByAppIdAndActivityId(appId, activityIds, type),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findDuibaQuizzByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type) {
        return BeanUtils.copyList(operatingActivityDao.findDuibaQuizzByAppIdAndActivityId(appId, activityIds, type),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findDuibaSeckillByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type) {
        if(CollectionUtils.isEmpty(activityIds)){
            return Lists.newArrayList();
        }
        return BeanUtils.copyList(operatingActivityDao.findDuibaSeckillByAppIdAndActivityId(appId, activityIds, type),OperatingActivityDto.class);
    }

    @Override
    public List<ActivityDto> findOnlineActivity(Map<String, Object> params) {
        return BeanUtils.copyList(operatingActivityDao.findOnlineActivity(params),ActivityDto.class);
    }

    @Override
    public List<ActivityDto> findOnlineActivityWithOutTopic(Map<String, Object> params) {
        return BeanUtils.copyList(operatingActivityDao.findOnlineActivityWithOutTopic(params),ActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaGuessIdAndDeleted(Long duibaGuessId, Boolean deleted) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaGuessIdAndDeleted(duibaGuessId, deleted),OperatingActivityDto.class);
    }

    @Override
    public List<Long> findAppIdsByDuibaGuessId(Long duibaGuessId) {
        return operatingActivityDao.findAppIdsByDuibaGuessId(duibaGuessId);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaNgameId(Long duibaNgameId) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaNgameId(duibaNgameId),OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaGuessId(Long duibaGuessId) {
        return BeanUtils.copyList(operatingActivityDao.findAllByDuibaGuessId(duibaGuessId),OperatingActivityDto.class);
    }

    @Override public List<OperatingActivityDto> findDuibaNgameByAppIdAndActivityId(Long appId, List<Long> activityIds,
                                                                                  Integer type) {
        return BeanUtils.copyList(operatingActivityDao.findDuibaNgameByAppIdAndActivityId(appId, activityIds, type),OperatingActivityDto.class);
    }

    @Override public List<OperatingActivityDto> findDuibaGuessByAppIdAndActivityId(Long appId, List<Long> activityIds,
                                                                                  Integer type) {
        return BeanUtils.copyList(operatingActivityDao.findDuibaGuessByAppIdAndActivityId(appId, activityIds, type),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaGuessIdAndDeleted(Long appId, Long duibaGuessId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdAndDuibaGuessIdAndDeleted(appId, duibaGuessId, deleted),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaNgameActivityIdAndDeleted(Long appId, Long duibaNgameActivityId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdAndDuibaNgameActivityIdAndDeleted(appId, duibaNgameActivityId, deleted),OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaGuessActivityIdAndDeleted(Long appId, Long duibaGuessActivityId, Boolean deleted) {
        return BeanUtils.copy(operatingActivityDao.findByAppIdAndDuibaGuessActivityIdAndDeleted(appId, duibaGuessActivityId, deleted),OperatingActivityDto.class);
    }

    @Override
    public List<Long> findSeckillIdsByActivityId(Long duibaSeckillId) {
        return  operatingActivityDao.findSeckillIdsByActivityId(duibaSeckillId);
    }

    @Override
    public OperatingActivityDto findById(Long id) {
        return BeanUtils.copy(operatingActivityDao.select(id),OperatingActivityDto.class);
    }

    @Override
    public List<Long> findAppIdsByIds(List<Long> ids){
        return operatingActivityDao.findAppIdsByIds(ids);
    }


    @Override
    public void insertUnique(OperatingActivityDto operatingActivityDto) {
        OperatingActivityEntity entity=new OperatingActivityEntity(true);
        BeanUtils.copy(operatingActivityDto,entity);
        operatingActivityDao.insert(entity);
        operatingActivityDto.setId(entity.getId());
    }
    
	@Override
	public int updateVisitTimes(Long operatingActivityId, int offset) {
		int ret = operatingActivityDao.updateWin(operatingActivityId, offset);
        cacheClient.remove(getCacheKeyById(operatingActivityId));
        return ret;
	}


    @Override
    public List<OperatingActivityDto> findByActivityId(Long activityId) {
        return BeanUtils.copyList(operatingActivityDao.findByActivityId(activityId), OperatingActivityDto.class);
    }
}
