package cn.com.duiba.activity.center.biz.service.elasticgifts;

import cn.com.duiba.activity.center.api.dto.elasticgifts.*;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsBizCodeEnum;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsStatusEnum;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.dcommons.domain.Tuple;

import java.util.List;

/**
 * 弹层活动 service
 */
public interface ElasticGiftsService {

    /**
     * 获取弹层礼包分页
     * @param currentPage
     * @param pageSize
     * @param bizCode
     * @param elasticGiftsId
     * @param title4admin
     * @return
     */
    Page<ElasticGiftsListDto> findElasticGiftsPage(Integer currentPage, Integer pageSize, ElasticGiftsBizCodeEnum bizCode, Long elasticGiftsId, String title4admin);

    /**
     * 更新状态
     * @param elasticGiftsId
     * @param targetStatus
     * @return
     */
    Boolean updateStatus(Long elasticGiftsId, ElasticGiftsStatusEnum targetStatus);

    /**
     * 根据 活动 id,获取 appids
     * @param elasticGiftsId
     * @return
     */
    List<Long> getAppIdsByElasticGiftsId(Long elasticGiftsId);

    /**
     * 删除
     * @param elasticGiftsId
     * @return
     */
    Boolean delete(Long elasticGiftsId);

    /**
     * 保存
     * @param elasticGiftsId
     * @param title4admin
     * @param bizCode
     * @param termIds
     * @return
     */
    Boolean save(Long elasticGiftsId, String title4admin, ElasticGiftsBizCodeEnum bizCode, List<Long> termIds);

    /**
     * 根据 id 获取对象
     * @param elasticGiftsId
     * @return
     */
    ElasticGiftsEditDto getElasticGiftsById(Long elasticGiftsId);

    /**
     * 根据文案查询活动
     * @param bizCode
     * @param text
     * @return
     */
    List<ElasticGiftsDto> getElasticGiftsByText(ElasticGiftsBizCodeEnum bizCode, String text);

    /**
     * 手机端获取礼包项 s 根据 appid
     * @param appId
     * @return
     */
    Tuple.Tuple2<ElasticGiftsDto,List<ElasticGiftsTermDto>> getElasticGiftsForMobile(ElasticGiftsBizCodeEnum bizCode, Long appId) throws Exception;

    /**
     * 下单接口
     * @param dto
     * @param itemId
     * @param consumerId
     * @param ip
     * @param ua
     * @return
     */
    String takeOrder(ElasticGiftsDto dto, Long itemId, Long appId, Long consumerId, RequestParamsDto requestParams) throws Exception;

    /**
     * 活动下单校验接口
     * @param egTermId
     * @param appId
     * @return
     */
    ElasticTakeOrderDto checkElasticTakeOrder(Long egTermId, Long appId) throws Exception;
}
