package cn.com.duiba.activity.center.biz.service.elasticgifts;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermSimpleDto;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsTermTypeEnum;

import java.util.List;

/**
 * 弹层礼包项 service
 */
public interface ElasticGiftsTermService {

    /**
     * 根据活动 id 获取活动项
     * @param elasticGiftsId
     * @return
     */
    List<ElasticGiftsTermSimpleDto> getTermsByElasticGiftsId(Long elasticGiftsId);

    /**
     * 排序
     * @param ids
     * @return
     */
    Boolean sortTerms(List<Long> ids);

    /**
     * 删除
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 保存
     * @param id
     * @param typeEnum
     * @param termId
     * @param elasticGiftsId
     * @param title
     * @param subtitle
     * @param payIntro
     * @param btnText
     * @return
     */
    Boolean save(Long id, ElasticGiftsTermTypeEnum typeEnum, Long termId, Long elasticGiftsId, String title, String subtitle, String payIntro, String btnText);

    /**
     * 根据 id 获取礼包项
     * @param id
     * @return
     */
    ElasticGiftsTermDto getTermById(Long id);
}
