package cn.com.duiba.activity.center.biz.service.elasticgifts.impl;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermSimpleDto;
import cn.com.duiba.activity.center.api.enums.DeletedEnum;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsTermTypeEnum;
import cn.com.duiba.activity.center.biz.dao.elasticgifts.ElasticGiftsTermDao;
import cn.com.duiba.activity.center.biz.entity.elasticgifts.ElasticGiftsTermEntity;
import cn.com.duiba.activity.center.biz.service.elasticgifts.ElasticGiftsTermService;
import com.google.common.base.Preconditions;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("elasticGiftsTermService")
public class ElasticGiftsTermServiceImpl implements ElasticGiftsTermService {

    @Autowired
    private ElasticGiftsTermDao elasticGiftsTermDao;

    @Override
    public List<ElasticGiftsTermSimpleDto> getTermsByElasticGiftsId(Long elasticGiftsId) {
        Preconditions.checkNotNull(elasticGiftsId, "活动 id 不能为 null");
        List<ElasticGiftsTermEntity> entities = elasticGiftsTermDao.findAllByElId(elasticGiftsId);
        List<ElasticGiftsTermSimpleDto> result = new ArrayList<>();
        for (ElasticGiftsTermEntity it : entities) {
            result.add(new ElasticGiftsTermSimpleDto(it.getId(), it.getTermId(), it.getPayload()));
        }
        return result;
    }

    @Override
    public Boolean sortTerms(List<Long> ids) {
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(ids), "ids 不能为 null");
        int payload = 1;
        for (Long it : ids) {
            elasticGiftsTermDao.updatePayloadById(it, payload++);
        }
        return true;
    }

    @Override
    public Boolean delete(Long id) {
        Preconditions.checkNotNull(id, "id 不能为 null");
        return elasticGiftsTermDao.delete(id) > 0;
    }

    @Override
    public Boolean save(Long id, ElasticGiftsTermTypeEnum typeEnum, Long termId, Long elasticGiftsId, String title, String subtitle, String payIntro, String btnText) {
        Preconditions.checkNotNull(typeEnum, "礼包项类型不能为 null");
        Preconditions.checkNotNull(termId, "礼包项id不能为 null");
        Preconditions.checkNotNull(elasticGiftsId, "礼包id不能为 null");
        if (isCreate(id)) {
            ElasticGiftsTermEntity e4i = new ElasticGiftsTermEntity();
            e4i.setPayload(elasticGiftsTermDao.getMaxPayload() + 1);
            e4i.setTermType(typeEnum.value());
            e4i.setTermId(termId);
            e4i.setElasticGiftsId(elasticGiftsId);
            e4i.setTitle(title);
            e4i.setSubtitle(subtitle);
            e4i.setPayIntro(payIntro);
            e4i.setBtnText(btnText);
            e4i.setDeleted(DeletedEnum.UNDELETED.value());
            return elasticGiftsTermDao.insert(e4i) > 0;
        } else {
            ElasticGiftsTermEntity e4u = new ElasticGiftsTermEntity();
            e4u.setId(id);
            e4u.setElasticGiftsId(elasticGiftsId);
            e4u.setTermType(typeEnum.value());
            e4u.setTermId(termId);
            e4u.setTitle(title);
            e4u.setSubtitle(subtitle);
            e4u.setPayIntro(payIntro);
            e4u.setBtnText(btnText);
            return elasticGiftsTermDao.update(e4u) > 0;
        }

    }

    /**
     * 判断是否是创建操作
     * @param id
     * @return
     */
    private boolean isCreate(Long id) {
        return id == null;
    }

    @Override
    public ElasticGiftsTermDto getTermById(Long id) {
        Preconditions.checkNotNull(id, "id 不能为 null");
        ElasticGiftsTermEntity entity = elasticGiftsTermDao.find(id);
        Preconditions.checkNotNull(entity, "term 不存在");
        ElasticGiftsTermDto dto = new ElasticGiftsTermDto();
        BeanUtils.copyProperties(entity, dto, "termType", "deleted");
        dto.setDeleted(DeletedEnum.fromValue(entity.getDeleted()));
        dto.setTermType(ElasticGiftsTermTypeEnum.fromValue(entity.getTermType()));
        return dto;
    }
}
