package cn.com.duiba.activity.center.biz.service.game;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.game.GameOrdersDto;
import cn.com.duiba.activity.center.api.dto.game.GameOrdersSimpleDto;

public interface GameOrdersSimpleService {

	public GameOrdersDto find(Long gameOrderId);

	public GameOrdersDto findByAppAndDeveloperBizId(Long appId, String bizId);

	public List<GameOrdersDto> findByIds(List<Long> ids);

	public void insert(GameOrdersDto gameOrdersDO);

	public Integer findConsumerFreeNumber(Long consumerId, Long operatingActivityId);

	public Integer findConsumerFreeNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end);

	public Integer findConsumerLimitNumber(Long consumerId, Long operatingActivityId);

	public Integer findConsumerLimitNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end);

	public Integer countConsumerByPrizeId(Long consumerId, Long operatingActivityId, Long prizeId);

	public Integer countConsumerByGameConfigDuibaId(Long consumerId, Long gameConfigDuibaId);

	public List<Long> findOverdueOrder();

	public Long countRow(Map<String, Object> params);

	public List<GameOrdersSimpleDto> findByLimit(Map<String, Object> params);

	public List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(List<Long> ids);

}
