package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerAppSpecifyDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerAppSpecifyDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerAppSpecifyEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerAppSpecifyService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import static cn.com.duiba.wolf.utils.BeanUtils.copy;

/**
 * Created by wenqi.huang on 16/5/24.
 */
@Service
public class DuibaQuestionAnswerAppSpecifyServiceImpl implements DuibaQuestionAnswerAppSpecifyService {
    @Resource
    private DuibaQuestionAnswerAppSpecifyDao duibaQuestionAnswerAppSpecifyDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKey(Long questionId, Long appId){
        return CacheConstants.KEY_QUESTION_ANSWER_APP_SPECIFY_BY_QID_AID + questionId + "_" + appId;
    }

    @Override
    public DuibaQuestionAnswerAppSpecifyDto findByQuestionAnswerIdAndAppId(final Long questionId, final Long appId) {
        String key = getCacheKey(questionId, appId);
        return cacheClient.getWithCacheLoader(key, 30, TimeUnit.MINUTES,true, new CacheLoader<DuibaQuestionAnswerAppSpecifyDto>(){

            @Override
            public DuibaQuestionAnswerAppSpecifyDto load() {
                return BeanUtils.copy(duibaQuestionAnswerAppSpecifyDao.findByQuestionAnswerIdAndAppId(questionId, appId), DuibaQuestionAnswerAppSpecifyDto.class);
            }
        });
    }

    public Map<Long, DuibaQuestionAnswerAppSpecifyDto> findByQuestionAnswerIdsAndAppId(List<Long> questionIds, Long appId){
        List<DuibaQuestionAnswerAppSpecifyEntity> list = duibaQuestionAnswerAppSpecifyDao.findByQuestionAnswerIdsAndAppId(questionIds, appId);
        Map<Long, DuibaQuestionAnswerAppSpecifyDto> map = new HashMap<>();
        for(DuibaQuestionAnswerAppSpecifyEntity e : list){
            map.put(e.getDuibaQuestionAnswerId(), BeanUtils.copy(e, DuibaQuestionAnswerAppSpecifyDto.class));
        }

        return map;
    }

    @Override
    public List<DuibaQuestionAnswerAppSpecifyDto> findByDuibaQuestionAnswerId(Long duibaQuestionAnswerId) {
        return BeanUtils.copyList(duibaQuestionAnswerAppSpecifyDao.findByDuibaQuestionAnswerId(duibaQuestionAnswerId), DuibaQuestionAnswerAppSpecifyDto.class);
    }

    @Override
    public void delete(Long id) {
        DuibaQuestionAnswerAppSpecifyEntity dto = duibaQuestionAnswerAppSpecifyDao.find(id);
        if(dto != null) {
            duibaQuestionAnswerAppSpecifyDao.delete(id);
            cacheClient.remove(getCacheKey(dto.getDuibaQuestionAnswerId(), dto.getAppId()));
        }
    }

    @Override
    public void insert(DuibaQuestionAnswerAppSpecifyDto duibaQuestionAnswerAppSpecify) {
        DuibaQuestionAnswerAppSpecifyEntity e = copy(duibaQuestionAnswerAppSpecify, DuibaQuestionAnswerAppSpecifyEntity.class);
        duibaQuestionAnswerAppSpecifyDao.insert(e);
        duibaQuestionAnswerAppSpecify.setId(e.getId());
        cacheClient.remove(getCacheKey(duibaQuestionAnswerAppSpecify.getDuibaQuestionAnswerId(), duibaQuestionAnswerAppSpecify.getAppId()));
    }

    @Override
    public DuibaQuestionAnswerAppSpecifyDto find(Long id) {
        return copy(duibaQuestionAnswerAppSpecifyDao.find(id), DuibaQuestionAnswerAppSpecifyDto.class);
    }
}
