package cn.com.duiba.activity.center.biz.service.guess.impl;

import cn.com.duiba.activity.center.api.dto.guess.GuessOrdersExtraDto;
import cn.com.duiba.activity.center.biz.dao.guess.GuessOrdersExtraDao;
import cn.com.duiba.activity.center.biz.entity.guess.GuessOrdersExtraEntity;
import cn.com.duiba.activity.center.biz.service.guess.GuessOrdersExtraService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/7/18.
 */
@Service
public class GuessOrdersExtraServiceImpl implements GuessOrdersExtraService {

    @Autowired
    private GuessOrdersExtraDao guessOrdersExtraDao;

    @Override
    public GuessOrdersExtraDto find(Long id) {
        return BeanUtils.copy(guessOrdersExtraDao.find(id),GuessOrdersExtraDto.class);
    }

    @Override
    public void insert(GuessOrdersExtraDto guessOrdersExtraDto) {
        GuessOrdersExtraEntity entity=BeanUtils.copy(guessOrdersExtraDto,GuessOrdersExtraEntity.class);
        guessOrdersExtraDao.insert(entity);
        guessOrdersExtraDto.setId(entity.getId());
    }

    @Override
    public int updateOrderId(Long id, Long mainOrderId, String mainOrderNum) {
        return guessOrdersExtraDao.updateOrderId(id,mainOrderId,mainOrderNum);
    }

    @Override
    public List<Long> findWiningPrizeIds(Long consumerId, Long duibaGuessId) {
        return guessOrdersExtraDao.findWiningPrizeIds(consumerId,duibaGuessId);
    }

    @Override
    public void updateNotPrize(Long guessExtraOrderId) {
        guessOrdersExtraDao.updateNotPrize(guessExtraOrderId);
    }
}
