package cn.com.duiba.activity.center.biz.service.seckill;

import cn.com.duiba.activity.center.biz.entity.seckill.DuibaSeckillEntity;

import java.util.Date;

public interface SeckillDateUtilService {

	/**
	 * 当前时间是否在开始前5分钟-开始后5分钟之间
	 */
	boolean isNowBeforeAfter5Min(DuibaSeckillEntity duibaSeckill, Date now);

	/**
	 * 判断当前时间，是不是在活动开始时间前一小时-结束时间之间
	 */
	boolean isNowOneHourOngoing(DuibaSeckillEntity duibaSeckill, Date now);

	/**
	 * 判断当前时间是不是在活动开始时间-结束时间之间
	 */
	boolean isNowOngoing(DuibaSeckillEntity duibaSeckill, Date now);

	/**
	 * 判断当前日期，是否还没开始
	 */
	boolean isNowDateGoingStart(DuibaSeckillEntity duibaSeckill, Date now);

	/**
	 * 判断当前日期，是否在结束日期之后
	 */
	boolean isNowDateOver(DuibaSeckillEntity duibaSeckill, Date now);

	/**
	 * 判断当前日期，是否在活动日子之间
	 */
	boolean isNowDateOngoing(DuibaSeckillEntity duibaSeckill, Date now);

	/**
	 * 判断当前时间，是否还没开始
	 */
	boolean isNowTimeGoingStart(DuibaSeckillEntity duibaSeckill, Date now);

	/**
	 * 判断当前时间，是否已经结束
	 */
	boolean isNowTimeOver(DuibaSeckillEntity duibaSeckill, Date now);

}
