package cn.com.duiba.activity.center.biz.service.seckill.impl;

import cn.com.duiba.activity.center.biz.entity.seckill.DuibaSeckillEntity;
import cn.com.duiba.activity.center.biz.service.seckill.SeckillDateUtilService;
import cn.com.duiba.activity.center.common.util.DateUtil;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;

@Service("seckillDateUtilService")
public class SeckillDateUtilServiceImpl implements SeckillDateUtilService {

	@Override
	public boolean isNowDateOngoing(DuibaSeckillEntity duibaSeckill, Date now) {
		String startDay = DateUtil.getDayStr(duibaSeckill.getDateStart());
		String endDay = DateUtil.getDayStr(duibaSeckill.getDateEnd());
		Date start = DateUtil.getDayDate(startDay);
		Calendar cal = Calendar.getInstance();
		cal.setTime(DateUtil.getDayDate(endDay));
		cal.add(Calendar.DATE, 1);
		Date end = cal.getTime();
		if (now.getTime() < start.getTime() || now.getTime() > end.getTime()) {
			return false;
		}
		return true;
	}

	@Override
	public boolean isNowDateGoingStart(DuibaSeckillEntity duibaSeckill, Date now) {
		String startDay = DateUtil.getDayStr(duibaSeckill.getDateStart());
		Date start = DateUtil.getDayDate(startDay);
		if (System.currentTimeMillis() < start.getTime()) {
			return true;
		}
		return false;
	}

	@Override
	public boolean isNowTimeGoingStart(DuibaSeckillEntity duibaSeckill, Date now) {
		String startTime = DateUtil.getMinuteOnlyStr(duibaSeckill.getTimeStart());
		String nowTime = DateUtil.getMinuteOnlyStr(now);
		if (DateUtil.compareHHmmInString(nowTime, startTime) < 0) {
			return true;
		}
		return false;
	}

	@Override
	public boolean isNowDateOver(DuibaSeckillEntity duibaSeckill, Date now) {
		String endDay = DateUtil.getDayStr(duibaSeckill.getDateEnd());
		Calendar cal = Calendar.getInstance();
		cal.setTime(DateUtil.getDayDate(endDay));
		cal.add(Calendar.DATE, 1);
		Date end = cal.getTime();
		if (System.currentTimeMillis() > end.getTime()) {
			return true;
		}
		return false;
	}

	@Override
	public boolean isNowTimeOver(DuibaSeckillEntity duibaSeckill, Date now) {
		String endTime = DateUtil.getMinuteOnlyStr(duibaSeckill.getTimeEnd());
		String nowTime = DateUtil.getMinuteOnlyStr(now);
		if (DateUtil.compareHHmmInString(endTime, nowTime) < 0) {
			return true;
		}
		return false;
	}

	@Override
	public boolean isNowOngoing(DuibaSeckillEntity duibaSeckill, Date now) {
		String startTime = DateUtil.getMinuteOnlyStr(duibaSeckill.getTimeStart());
		String endTime = DateUtil.getMinuteOnlyStr(duibaSeckill.getTimeEnd());
		String nowTime = DateUtil.getMinuteOnlyStr(now);
		if (DateUtil.betweenHHmmInString(nowTime, startTime, endTime) == 1) {
			return true;
		}
		return false;
	}

	@Override
	public boolean isNowOneHourOngoing(DuibaSeckillEntity duibaSeckill, Date now) {
		if (isNowOngoing(duibaSeckill, now)) {
			return true;
		}
		String nowTime = DateUtil.getMinuteOnlyStr(now);
		String oneHourAfterNowTime = (DateUtil.getHour(nowTime) + 1) + ":" + DateUtil.getMinute(nowTime);
		String startTime = DateUtil.getMinuteOnlyStr(duibaSeckill.getTimeStart());
		if (DateUtil.compareHHmmInString(nowTime, startTime) <= 0 && DateUtil.compareHHmmInString(oneHourAfterNowTime, startTime) >= 0) {
			return true;
		}
		return false;
	}

	@Override
	public boolean isNowBeforeAfter5Min(DuibaSeckillEntity duibaSeckill, Date now) {
		String startTime = DateUtil.getMinuteOnlyStr(DateUtil.minutesAddOrSub(duibaSeckill.getTimeStart(), -5));
		String endTime = DateUtil.getMinuteOnlyStr(DateUtil.minutesAddOrSub(duibaSeckill.getTimeEnd(), 5));
		String nowTime = DateUtil.getMinuteOnlyStr(now);
		if (DateUtil.betweenHHmmInString(nowTime, startTime, endTime) == 1) {
			return true;
		}
		return false;
	}
}
