package cn.com.duiba.activity.center.biz.service.seckill.impl;

import cn.com.duiba.activity.center.biz.constant.MemcachedSpace;
import cn.com.duiba.activity.center.biz.entity.seckill.DuibaSeckillStockConfigEntity;
import cn.com.duiba.activity.center.biz.service.seckill.SeckillMemcacheService;
import cn.com.duiba.activity.center.biz.service.seckill.SeckillStockService;
import cn.com.duiba.activity.center.common.util.DateUtil;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.wolf.cache.CacheClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("seckillMemcacheService")
public class SeckillMemcacheServiceImpl implements SeckillMemcacheService {

	private static Logger LOGGER = LoggerFactory.getLogger(SeckillServiceImpl.class);

	@Autowired
	private RemoteAppService remoteAppService;

	@Autowired
	private CacheClient memcachedClient;

	@Autowired
	private SeckillStockService seckillStockService;

	private String getStockKey(Long stockId) {
		return MemcachedSpace.MS_SECKILL_STOCK + stockId;
	}

	@Override
	public Long getMemcachedStockById(Long stockId, Long duibaSeckillId, Long appId) {
		String stock = (String) memcachedClient.get(getStockKey(stockId));
		if (stock == null) {
			DuibaSeckillStockConfigEntity stockConfig = seckillStockService.findStockByUnique(duibaSeckillId, appId);
			Integer exp = DateUtil.getToTomorrowSeconds(); // 到下一天凌晨0点失效
			try {
				memcachedClient.add(getStockKey(stockConfig.getId()), exp, stockConfig.getStock() + "");
			} catch (Exception e) {
				LOGGER.error("getMemcachedStockById memcachedClient.add error", e);
			}
			return Long.valueOf(stockConfig.getStock());
		}
		return Long.valueOf(stock.trim());
	}

	@Override
	public void invalidateStockCacheById(Long stockId) {
		memcachedClient.remove(getStockKey(stockId));
	}

}
