/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.bo.stock;

import cn.com.duiba.activity.center.api.dto.chaos.ActPreConsumeStockDto;
import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreConsumerStockService;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.service.exception.BusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActStockConsumerBo {
    private static Logger log = LoggerFactory.getLogger(ActStockConsumerBo.class);
    @Autowired
    private ActPreStockSerivce actPreStockSerivce;
    @Autowired
    private ActPreConsumerStockService actPreConsumerStockService;

    public void consumeActStock(Long prizeId, String bizId, String bizSource, Long appId) throws BusinessException {
        Long relationPrizeId = prizeId;
        String relationType = bizSource;
        ActPreStockDto actPreStock = this.findActValidStock(relationPrizeId, relationType, appId);
        if (null == actPreStock) {
            throw new BusinessException("\u9884\u5206\u914d\u5e93\u5b58\u4e0d\u5b58\u5728");
        }
        Long preStockId = actPreStock.getId();
        if (actPreStock.getPrizeQuantity() != null && actPreStock.getPrizeQuantity() <= 0L) {
            throw new BusinessException("\u9884\u5206\u914d\u5e93\u5b58\u4e0d\u8db3");
        }
        int ret = this.actPreStockSerivce.decrementRemaining(preStockId);
        if (ret < 1) {
            throw new BusinessException("\u66f4\u65b0\u5151\u5427\u6d3b\u52a8\u5956\u9879\u9884\u5206\u914d\u5e93\u5b58\u5f02\u5e38");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        ActPreConsumeStockDto actStockConsumer = new ActPreConsumeStockDto(true);
        actStockConsumer.setAppId(appId);
        actStockConsumer.setBizId(bizId);
        actStockConsumer.setBizSource(bizSource);
        actStockConsumer.setPreStockId(preStockId);
        actStockConsumer.setQuantity(Long.valueOf(1L));
        actStockConsumer.setAction("pay");
        actStockConsumer.setGmtCreate(now);
        actStockConsumer.setGmtModified(now);
        this.actPreConsumerStockService.insert(actStockConsumer);
    }

    public void paybackActStock(String bizId, String bizSource) throws BusinessException {
        ActPreConsumeStockDto consume = this.actPreConsumerStockService.findPreConsumerByBizPay(bizId, bizSource);
        if (null == consume) {
            log.error("\u5956\u9879\u5e93\u5b58\u6d88\u8d39\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        ActPreStockDto actPreStockLock = this.actPreStockSerivce.find(consume.getPreStockId());
        if (null == actPreStockLock) {
            log.error("\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        int ret = this.actPreStockSerivce.incrementRemaining(actPreStockLock.getId());
        if (ret < 1) {
            throw new BusinessException("\u66f4\u65b0\u5151\u5427\u6d3b\u52a8\u5956\u9879\u9884\u5206\u914d\u4e2a\u6570\u5f02\u5e38");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        ActPreConsumeStockDto actStockConsumer = new ActPreConsumeStockDto(true);
        actStockConsumer.setAppId(consume.getAppId());
        actStockConsumer.setBizId(consume.getBizId());
        actStockConsumer.setBizSource(consume.getBizSource());
        actStockConsumer.setPreStockId(consume.getPreStockId());
        actStockConsumer.setQuantity(consume.getQuantity());
        actStockConsumer.setAction("back");
        actStockConsumer.setGmtCreate(now);
        actStockConsumer.setGmtModified(now);
        this.actPreConsumerStockService.insert(actStockConsumer);
    }

    public ActPreStockDto findActValidStock(Long relationPrizeId, String relationType, Long appId) {
        ActPreStockDto preStock = this.actPreStockSerivce.findPreStockByApp(relationPrizeId, relationType, appId);
        if (null == preStock) {
            preStock = this.actPreStockSerivce.findPreStockByShare(relationPrizeId, relationType);
        }
        return preStock;
    }
}

