/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.dao.guess.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.guess.GuessOrdersStatusChangeDao;
import cn.com.duiba.activity.center.biz.support.TableHelper;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class GuessOrdersStatusChangeDaoImpl
extends ActivityBaseDao
implements GuessOrdersStatusChangeDao {
    @Override
    public int updateStatusToConsumeSuccess(Long consumerId, Long gameOrderId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", gameOrderId);
        paramMap.put("status", 1);
        int ret = this.update("updateStatusToConsumeSuccess", paramMap);
        return ret;
    }

    @Override
    public int updateStatusToFail(Long consumerId, Long guessOrderId, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("status", 3);
        paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
        paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
        paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
        int ret = this.update("updateStatusToFail", paramMap);
        return ret;
    }

    @Override
    public int updateStatusToSuccess(Long consumerId, Long guessOrderId, Long guessOrderExtraId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("status", 2);
        paramMap.put("guessOrderExtraId", guessOrderExtraId);
        int ret = this.update("updateStatusToSuccess", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpen(Long consumerId, Long guessOrderId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("status", 2);
        paramMap.put("exchangeStatus", 1);
        int ret = this.update("updateExchangeStatusToWaitOpen", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToWait(Long consumerId, Long guessOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("status", 2);
        paramMap.put("exchangeStatus", 2);
        paramMap.put("itemId", itemId);
        paramMap.put("appItemId", appItemId);
        paramMap.put("prizeId", prizeId);
        paramMap.put("prizeType", prizeType);
        paramMap.put("prizeName", prizeName);
        paramMap.put("prizeFacePrice", prizeFacePrice);
        paramMap.put("couponId", couponId);
        int ret = this.update("updateExchangeStatusToWait", paramMap);
        return ret;
    }

    @Override
    public int doTakePrize(Long consumerId, Long id) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        int ret = this.update("doTakePrize", paramMap);
        return ret;
    }

    @Override
    public int rollbackTakePrize(Long consumerId, Long id) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        int ret = this.update("rollbackTakePrize", paramMap);
        return ret;
    }

    @Override
    public int updateManualOpenPrizeExchangeStatusToWait(Long consumerId, Long guessOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("exchangeStatus", 2);
        paramMap.put("itemId", itemId);
        paramMap.put("appItemId", appItemId);
        paramMap.put("prizeId", prizeId);
        paramMap.put("prizeType", prizeType);
        paramMap.put("prizeName", prizeName);
        paramMap.put("prizeFacePrice", prizeFacePrice);
        paramMap.put("couponId", couponId);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, 7);
        Date prizeOverdueDate = cal.getTime();
        paramMap.put("prizeOverdueDate", prizeOverdueDate);
        int ret = this.update("updateManualOpenPrizeExchangeStatusToWait", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToFail(Long consumerId, Long guessOrderId, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("exchangeStatus", 5);
        paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
        paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
        paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
        int ret = this.update("updateExchangeStatusToFail", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraId(Long consumerId, Long guessOrderId, Long guessOrderExtraId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("status", 2);
        paramMap.put("exchangeStatus", 1);
        paramMap.put("guessOrderExtraId", guessOrderExtraId);
        int ret = this.update("updateExchangeStatusToWaitOpenAndExtraId", paramMap);
        return ret;
    }

    @Override
    public int updateIsGivePrize(Long consumerId, Long id, int isGivePrize) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("isGivePrize", isGivePrize);
        int ret = this.update("updateIsGivePrize", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToOverdue(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("exchangeStatus", 4);
        paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
        paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
        paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
        int ret = this.update("updateExchangeStatusToOverdue", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraIdForLuck(Long consumerId, Long guessOrderId, Long guessOrderExtraId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("status", 2);
        paramMap.put("exchangeStatus", 1);
        paramMap.put("guessOrderExtraId", guessOrderExtraId);
        int ret = this.update("updateExchangeStatusToWaitOpenAndExtraId", paramMap);
        return ret;
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.GUESS_CON;
    }
}

