/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.plugin.stock;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsRegister;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.item.remoteservice.RemoteItemStockConsumeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityObjectStockPluginImpl
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(ActivityObjectStockPluginImpl.class);
    @Autowired
    private RemoteItemStockConsumeService remoteItemStockConsumeService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    private ActivityOrderSyncEvent orderPlugin = new ActivityOrderSyncEvent(){
        private static final String ACTIVITY_ObJ_STOCK = "__activity_obj_stock_consume";

        @Override
        public void afterOrderCreate(ActivityOrderDto order) {
        }

        @Override
        public void beforeStockComplete(ActivityOrderDto order, ActivityPrizeOptionDto option, ActivityOrderSyncEvent.ActivityOrderPluginContext context) throws Exception {
            if (option.getPrizeType().equals("object")) {
                try {
                    ItemKey key = ActivityObjectStockPluginImpl.this.remoteItemKeyService.getItemKey(option.getItemId(), option.getAppItemId(), order.getAppId());
                    ActivityObjectStockPluginImpl.this.remoteItemStockConsumeService.consumeStock(key, order.getOrderNum(), "activity");
                    context.setAttribute(ACTIVITY_ObJ_STOCK, true);
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: consumeStock,\u6d3b\u52a8\u5de5\u5177\u51cf\u5e93\u5b58\u5931\u8d25", (Throwable)e);
                    throw e;
                }
            }
        }

        @Override
        public void beforeStockCompleteException(ActivityOrderDto order, ActivityPrizeOptionDto option, Exception exception, ActivityOrderSyncEvent.ActivityOrderPluginContext context) {
            if (option.getPrizeType().equals("object")) {
                try {
                    Boolean hasadd = (Boolean)context.getAttribute(ACTIVITY_ObJ_STOCK);
                    if (hasadd != null && hasadd.booleanValue()) {
                        ActivityObjectStockPluginImpl.this.remoteItemStockConsumeService.paybackStock(order.getOrderNum(), "activity");
                    }
                    context.remove(ACTIVITY_ObJ_STOCK);
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: consumeStock,\u6d3b\u52a8\u5de5\u5177\u8fd4\u5e93\u5b58\u5931\u8d25", (Throwable)e);
                }
            }
        }
    };

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().addActivityOrdersPlugin(this.orderPlugin);
    }
}

